/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.SVGElement;
import elemental2.SVGURIReference;
import elemental2.SVGExternalResourcesRequired;
import elemental2.SVGStylable;
import elemental2.SVGAnimatedString;
import elemental2.SVGAnimatedBoolean;
import elemental2.SVGAnimatedTransformList;
import elemental2.SVGAnimatedEnumeration;
import java.lang.Object;
import elemental2.CSSValue;
import java.lang.String;
import jsinterop.annotations.JsProperty;
import elemental2.CSSStyleDeclaration;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class SVGGradientElement extends SVGElement implements SVGURIReference, SVGExternalResourcesRequired, SVGStylable {
  public static double SVG_SPREADMETHOD_PAD;
  public static double SVG_SPREADMETHOD_REFLECT;
  public static double SVG_SPREADMETHOD_REPEAT;
  public static double SVG_SPREADMETHOD_UNKNOWN;
  
  public SVGAnimatedString className;
  public SVGAnimatedBoolean externalResourcesRequired;
  public SVGAnimatedTransformList gradientTransform;
  public SVGAnimatedEnumeration gradientUnits;
  public SVGAnimatedString href;
  public SVGAnimatedEnumeration spreadMethod;
  public /* String | CSSStyleDeclaration */ Object style;
  
  public native CSSValue getPresentationAttribute(String name);

  public native CSSValue getPresentationAttribute();

  @JsProperty
  public native void setHref(SVGAnimatedString href);

  @JsProperty
  public native SVGAnimatedString getHref();

  @JsProperty
  public native void setExternalResourcesRequired(SVGAnimatedBoolean externalResourcesRequired);

  @JsProperty
  public native SVGAnimatedBoolean getExternalResourcesRequired();

  @JsProperty
  public native void setClassName(SVGAnimatedString className);

  @JsProperty
  public native SVGAnimatedString getClassName();

  @JsProperty
  public native void setStyle(/* String | CSSStyleDeclaration */ Object style);

  @JsProperty
  public native Object getStyle();

  @JsProperty(name = "style")
  public native String[] getStyleAsStringArray();

  @JsProperty(name = "style")
  public native CSSStyleDeclaration getStyleAsCSSStyleDeclaration();

}
