/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.SVGElement;
import elemental2.SVGURIReference;
import elemental2.SVGLangSpace;
import elemental2.SVGExternalResourcesRequired;
import elemental2.SVGFilterPrimitiveStandardAttributes;
import elemental2.SVGAnimatedString;
import elemental2.SVGAnimatedBoolean;
import elemental2.SVGAnimatedLength;
import elemental2.SVGAnimatedPreserveAspectRatio;
import java.lang.Object;
import java.lang.String;
import elemental2.CSSValue;
import jsinterop.annotations.JsProperty;
import elemental2.CSSStyleDeclaration;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class SVGFEImageElement extends SVGElement implements SVGURIReference, SVGLangSpace, SVGExternalResourcesRequired, SVGFilterPrimitiveStandardAttributes {
  public SVGAnimatedString className;
  public SVGAnimatedBoolean externalResourcesRequired;
  public SVGAnimatedLength height;
  public SVGAnimatedString href;
  public SVGAnimatedPreserveAspectRatio preserveAspectRatio;
  public SVGAnimatedString result;
  public /* String | CSSStyleDeclaration */ Object style;
  public SVGAnimatedLength width;
  public SVGAnimatedLength x;
  public String xmllang;
  public String xmlspace;
  public SVGAnimatedLength y;
  
  public native CSSValue getPresentationAttribute(String name);

  public native CSSValue getPresentationAttribute();

  @JsProperty
  public native void setHref(SVGAnimatedString href);

  @JsProperty
  public native SVGAnimatedString getHref();

  @JsProperty
  public native void setXmllang(String xmllang);

  @JsProperty
  public native String getXmllang();

  @JsProperty
  public native void setXmlspace(String xmlspace);

  @JsProperty
  public native String getXmlspace();

  @JsProperty
  public native void setExternalResourcesRequired(SVGAnimatedBoolean externalResourcesRequired);

  @JsProperty
  public native SVGAnimatedBoolean getExternalResourcesRequired();

  @JsProperty
  public native void setHeight(SVGAnimatedLength height);

  @JsProperty
  public native SVGAnimatedLength getHeight();

  @JsProperty
  public native void setResult(SVGAnimatedString result);

  @JsProperty
  public native SVGAnimatedString getResult();

  @JsProperty
  public native void setWidth(SVGAnimatedLength width);

  @JsProperty
  public native SVGAnimatedLength getWidth();

  @JsProperty
  public native void setX(SVGAnimatedLength x);

  @JsProperty
  public native SVGAnimatedLength getX();

  @JsProperty
  public native void setY(SVGAnimatedLength y);

  @JsProperty
  public native SVGAnimatedLength getY();

  @JsProperty
  public native void setClassName(SVGAnimatedString className);

  @JsProperty
  public native SVGAnimatedString getClassName();

  @JsProperty
  public native void setStyle(/* String | CSSStyleDeclaration */ Object style);

  @JsProperty
  public native Object getStyle();

  @JsProperty(name = "style")
  public native String[] getStyleAsStringArray();

  @JsProperty(name = "style")
  public native CSSStyleDeclaration getStyleAsCSSStyleDeclaration();

}
