/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.SVGElement;
import elemental2.SVGFilterPrimitiveStandardAttributes;
import elemental2.SVGAnimatedNumber;
import elemental2.SVGAnimatedString;
import elemental2.SVGAnimatedEnumeration;
import elemental2.SVGAnimatedLength;
import elemental2.SVGAnimatedNumberList;
import elemental2.SVGAnimatedInteger;
import elemental2.SVGAnimatedBoolean;
import java.lang.Object;
import elemental2.CSSValue;
import java.lang.String;
import jsinterop.annotations.JsProperty;
import elemental2.CSSStyleDeclaration;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class SVGFEConvolveMatrixElement extends SVGElement implements SVGFilterPrimitiveStandardAttributes {
  public static double SVG_EDGEMODE_DUPLICATE;
  public static double SVG_EDGEMODE_NONE;
  public static double SVG_EDGEMODE_UNKNOWN;
  public static double SVG_EDGEMODE_WRAP;
  
  public SVGAnimatedNumber bias;
  public SVGAnimatedString className;
  public SVGAnimatedNumber divisor;
  public SVGAnimatedEnumeration edgeMode;
  public SVGAnimatedLength height;
  public SVGAnimatedString in1;
  public SVGAnimatedNumberList kernelMatrix;
  public SVGAnimatedNumber kernelUnitLengthX;
  public SVGAnimatedNumber kernelUnitLengthY;
  public SVGAnimatedInteger orderX;
  public SVGAnimatedInteger orderY;
  public SVGAnimatedBoolean preserveAlpha;
  public SVGAnimatedString result;
  public /* String | CSSStyleDeclaration */ Object style;
  public SVGAnimatedInteger targetX;
  public SVGAnimatedInteger targetY;
  public SVGAnimatedLength width;
  public SVGAnimatedLength x;
  public SVGAnimatedLength y;
  
  public native CSSValue getPresentationAttribute(String name);

  public native CSSValue getPresentationAttribute();

  @JsProperty
  public native void setHeight(SVGAnimatedLength height);

  @JsProperty
  public native SVGAnimatedLength getHeight();

  @JsProperty
  public native void setResult(SVGAnimatedString result);

  @JsProperty
  public native SVGAnimatedString getResult();

  @JsProperty
  public native void setWidth(SVGAnimatedLength width);

  @JsProperty
  public native SVGAnimatedLength getWidth();

  @JsProperty
  public native void setX(SVGAnimatedLength x);

  @JsProperty
  public native SVGAnimatedLength getX();

  @JsProperty
  public native void setY(SVGAnimatedLength y);

  @JsProperty
  public native SVGAnimatedLength getY();

  @JsProperty
  public native void setClassName(SVGAnimatedString className);

  @JsProperty
  public native SVGAnimatedString getClassName();

  @JsProperty
  public native void setStyle(/* String | CSSStyleDeclaration */ Object style);

  @JsProperty
  public native Object getStyle();

  @JsProperty(name = "style")
  public native String[] getStyleAsStringArray();

  @JsProperty(name = "style")
  public native CSSStyleDeclaration getStyleAsCSSStyleDeclaration();

}
