/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.SVGElement;
import elemental2.SVGFilterPrimitiveStandardAttributes;
import elemental2.SVGAnimatedString;
import elemental2.SVGAnimatedLength;
import elemental2.SVGAnimatedEnumeration;
import java.lang.Object;
import elemental2.CSSValue;
import java.lang.String;
import jsinterop.annotations.JsProperty;
import elemental2.CSSStyleDeclaration;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class SVGFEBlendElement extends SVGElement implements SVGFilterPrimitiveStandardAttributes {
  public static double SVG_FEBLEND_MODE_DARKEN;
  public static double SVG_FEBLEND_MODE_LIGHTEN;
  public static double SVG_FEBLEND_MODE_MULTIPLY;
  public static double SVG_FEBLEND_MODE_NORMAL;
  public static double SVG_FEBLEND_MODE_SCREEN;
  public static double SVG_FEBLEND_MODE_UNKNOWN;
  
  public SVGAnimatedString className;
  public SVGAnimatedLength height;
  public SVGAnimatedString in1;
  public SVGAnimatedString in2;
  public SVGAnimatedEnumeration mode;
  public SVGAnimatedString result;
  public /* String | CSSStyleDeclaration */ Object style;
  public SVGAnimatedLength width;
  public SVGAnimatedLength x;
  public SVGAnimatedLength y;
  
  public native CSSValue getPresentationAttribute(String name);

  public native CSSValue getPresentationAttribute();

  @JsProperty
  public native void setHeight(SVGAnimatedLength height);

  @JsProperty
  public native SVGAnimatedLength getHeight();

  @JsProperty
  public native void setResult(SVGAnimatedString result);

  @JsProperty
  public native SVGAnimatedString getResult();

  @JsProperty
  public native void setWidth(SVGAnimatedLength width);

  @JsProperty
  public native SVGAnimatedLength getWidth();

  @JsProperty
  public native void setX(SVGAnimatedLength x);

  @JsProperty
  public native SVGAnimatedLength getX();

  @JsProperty
  public native void setY(SVGAnimatedLength y);

  @JsProperty
  public native SVGAnimatedLength getY();

  @JsProperty
  public native void setClassName(SVGAnimatedString className);

  @JsProperty
  public native SVGAnimatedString getClassName();

  @JsProperty
  public native void setStyle(/* String | CSSStyleDeclaration */ Object style);

  @JsProperty
  public native Object getStyle();

  @JsProperty(name = "style")
  public native String[] getStyleAsStringArray();

  @JsProperty(name = "style")
  public native CSSStyleDeclaration getStyleAsCSSStyleDeclaration();

}
