/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.SVGElement;
import elemental2.SVGTests;
import elemental2.SVGLangSpace;
import elemental2.SVGExternalResourcesRequired;
import elemental2.SVGStylable;
import elemental2.SVGTransformable;
import elemental2.SVGAnimatedString;
import elemental2.SVGAnimatedLength;
import elemental2.SVGAnimatedBoolean;
import elemental2.SVGStringList;
import java.lang.Object;
import elemental2.SVGAnimatedTransformList;
import java.lang.String;
import elemental2.SVGRect;
import elemental2.SVGMatrix;
import elemental2.CSSValue;
import jsinterop.annotations.JsProperty;
import elemental2.CSSStyleDeclaration;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class SVGEllipseElement extends SVGElement implements SVGTests, SVGLangSpace, SVGExternalResourcesRequired, SVGStylable, SVGTransformable {
  public SVGAnimatedString className;
  public SVGAnimatedLength cx;
  public SVGAnimatedLength cy;
  public SVGAnimatedBoolean externalResourcesRequired;
  public SVGElement farthestViewportElement;
  public SVGElement nearestViewportElement;
  public SVGStringList requiredExtensions;
  public SVGStringList requiredFeatures;
  public SVGAnimatedLength rx;
  public SVGAnimatedLength ry;
  public /* String | CSSStyleDeclaration */ Object style;
  public SVGStringList systemLanguage;
  public SVGAnimatedTransformList transform;
  public String xmllang;
  public String xmlspace;
  
  public native SVGRect getBBox();

  public native SVGMatrix getCTM();

  public native CSSValue getPresentationAttribute(String name);

  public native CSSValue getPresentationAttribute();

  public native SVGMatrix getScreenCTM();

  public native SVGMatrix getTransformToElement(SVGElement element);

  public native SVGMatrix getTransformToElement();

  public native boolean hasExtension(String extension);

  public native boolean hasExtension();

  @JsProperty
  public native void setRequiredExtensions(SVGStringList requiredExtensions);

  @JsProperty
  public native SVGStringList getRequiredExtensions();

  @JsProperty
  public native void setRequiredFeatures(SVGStringList requiredFeatures);

  @JsProperty
  public native SVGStringList getRequiredFeatures();

  @JsProperty
  public native void setSystemLanguage(SVGStringList systemLanguage);

  @JsProperty
  public native SVGStringList getSystemLanguage();

  @JsProperty
  public native void setXmllang(String xmllang);

  @JsProperty
  public native String getXmllang();

  @JsProperty
  public native void setXmlspace(String xmlspace);

  @JsProperty
  public native String getXmlspace();

  @JsProperty
  public native void setExternalResourcesRequired(SVGAnimatedBoolean externalResourcesRequired);

  @JsProperty
  public native SVGAnimatedBoolean getExternalResourcesRequired();

  @JsProperty
  public native void setClassName(SVGAnimatedString className);

  @JsProperty
  public native SVGAnimatedString getClassName();

  @JsProperty
  public native void setStyle(/* String | CSSStyleDeclaration */ Object style);

  @JsProperty
  public native Object getStyle();

  @JsProperty(name = "style")
  public native String[] getStyleAsStringArray();

  @JsProperty(name = "style")
  public native CSSStyleDeclaration getStyleAsCSSStyleDeclaration();

  @JsProperty
  public native void setTransform(SVGAnimatedTransformList transform);

  @JsProperty
  public native SVGAnimatedTransformList getTransform();

  @JsProperty
  public native void setFarthestViewportElement(SVGElement farthestViewportElement);

  @JsProperty
  public native SVGElement getFarthestViewportElement();

  @JsProperty
  public native void setNearestViewportElement(SVGElement nearestViewportElement);

  @JsProperty
  public native SVGElement getNearestViewportElement();

}
