/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.EventTarget;
import jsinterop.annotations.JsFunction;
import elemental2.Event;
import java.lang.Object;
import elemental2.SVGElement;
import elemental2.SVGUseElement;
import java.lang.String;
import elemental2.SVGElementInstance.AddEventListenerListenerCallback;
import elemental2.EventListener;
import elemental2.SVGElementInstance.RemoveEventListenerListenerCallback;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class SVGElementInstance implements EventTarget {
  @JsFunction
  public interface AddEventListenerListenerCallback {
    boolean onInvoke(Event a);

  }
  @JsFunction
  public interface OnabortCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnbeforecopyCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnbeforecutCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnbeforepasteCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnblurCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnchangeCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnclickCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OncontextmenuCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OncopyCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OncutCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OndblclickCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OndragCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OndragendCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OndragenterCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OndragleaveCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OndragoverCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OndragstartCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OndropCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnerrorCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnfocusCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OninputCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnkeydownCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnkeypressCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnkeyupCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnloadCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnmousedownCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnmousemoveCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnmouseoutCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnmouseoverCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnmouseupCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnmousewheelCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnpasteCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnresetCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnresizeCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnscrollCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnsearchCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnselectCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnselectstartCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnsubmitCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnunloadCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface RemoveEventListenerListenerCallback {
    boolean onInvoke(Event a);

  }
  public /* SVGElementInstance | SVGElementInstanceList */ Object childNodes;
  public SVGElement correspondingElement;
  public SVGUseElement correspondingUseElement;
  public SVGElementInstance firstChild;
  public SVGElementInstance lastChild;
  public SVGElementInstance nextSibling;
  public /* EventListener | OnabortCallback */ Object onabort;
  public /* EventListener | OnbeforecopyCallback */ Object onbeforecopy;
  public /* EventListener | OnbeforecutCallback */ Object onbeforecut;
  public /* EventListener | OnbeforepasteCallback */ Object onbeforepaste;
  public /* EventListener | OnblurCallback */ Object onblur;
  public /* EventListener | OnchangeCallback */ Object onchange;
  public /* EventListener | OnclickCallback */ Object onclick;
  public /* EventListener | OncontextmenuCallback */ Object oncontextmenu;
  public /* EventListener | OncopyCallback */ Object oncopy;
  public /* EventListener | OncutCallback */ Object oncut;
  public /* EventListener | OndblclickCallback */ Object ondblclick;
  public /* EventListener | OndragCallback */ Object ondrag;
  public /* EventListener | OndragendCallback */ Object ondragend;
  public /* EventListener | OndragenterCallback */ Object ondragenter;
  public /* EventListener | OndragleaveCallback */ Object ondragleave;
  public /* EventListener | OndragoverCallback */ Object ondragover;
  public /* EventListener | OndragstartCallback */ Object ondragstart;
  public /* EventListener | OndropCallback */ Object ondrop;
  public /* EventListener | OnerrorCallback */ Object onerror;
  public /* EventListener | OnfocusCallback */ Object onfocus;
  public /* EventListener | OninputCallback */ Object oninput;
  public /* EventListener | OnkeydownCallback */ Object onkeydown;
  public /* EventListener | OnkeypressCallback */ Object onkeypress;
  public /* EventListener | OnkeyupCallback */ Object onkeyup;
  public /* EventListener | OnloadCallback */ Object onload;
  public /* EventListener | OnmousedownCallback */ Object onmousedown;
  public /* EventListener | OnmousemoveCallback */ Object onmousemove;
  public /* EventListener | OnmouseoutCallback */ Object onmouseout;
  public /* EventListener | OnmouseoverCallback */ Object onmouseover;
  public /* EventListener | OnmouseupCallback */ Object onmouseup;
  public /* EventListener | OnmousewheelCallback */ Object onmousewheel;
  public /* EventListener | OnpasteCallback */ Object onpaste;
  public /* EventListener | OnresetCallback */ Object onreset;
  public /* EventListener | OnresizeCallback */ Object onresize;
  public /* EventListener | OnscrollCallback */ Object onscroll;
  public /* EventListener | OnsearchCallback */ Object onsearch;
  public /* EventListener | OnselectCallback */ Object onselect;
  public /* EventListener | OnselectstartCallback */ Object onselectstart;
  public /* EventListener | OnsubmitCallback */ Object onsubmit;
  public /* EventListener | OnunloadCallback */ Object onunload;
  public SVGElementInstance parentNode;
  public SVGElementInstance previousSibling;
  
  public native void addEventListener(String type, AddEventListenerListenerCallback listener, boolean useCapture);

  public native void addEventListener(String type, EventListener listener, boolean useCapture);

  public native void addEventListener(String type, AddEventListenerListenerCallback listener);

  public native void addEventListener(String type, EventListener listener);

  public native boolean dispatchEvent(Event event);

  public native void removeEventListener(String type, RemoveEventListenerListenerCallback listener, boolean useCapture);

  public native void removeEventListener(String type, EventListener listener, boolean useCapture);

  public native void removeEventListener(String type, RemoveEventListenerListenerCallback listener);

  public native void removeEventListener(String type, EventListener listener);

  public native void addEventListener(String type, elemental2.EventTarget.AddEventListenerListenerCallback listener, boolean useCapture);

  public native void removeEventListener(String type, elemental2.EventTarget.RemoveEventListenerListenerCallback listener, boolean useCapture);

}
