/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.CSSValue;
import elemental2.RGBColor;
import java.lang.Object;
import java.lang.String;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class SVGColor extends CSSValue {
  public static double SVG_COLORTYPE_CURRENTCOLOR;
  public static double SVG_COLORTYPE_RGBCOLOR;
  public static double SVG_COLORTYPE_RGBCOLOR_ICCCOLOR;
  public static double SVG_COLORTYPE_UNKNOWN;
  
  public double colorType;
  public RGBColor rgbColor;
  
  public native Object setColor(double colorType, String rgbColor, String iccColor);

  public native Object setRGBColor(String rgbColor);

  public native Object setRGBColorICCColor(String rgbColor, String iccColor);

}
