/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.SVGElement;
import elemental2.SVGTests;
import elemental2.SVGExternalResourcesRequired;
import elemental2.ElementTimeControl;
import elemental2.SVGAnimatedBoolean;
import elemental2.SVGStringList;
import java.lang.Object;
import java.lang.String;
import jsinterop.annotations.JsProperty;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class SVGAnimationElement extends SVGElement implements SVGTests, SVGExternalResourcesRequired, ElementTimeControl {
  public SVGAnimatedBoolean externalResourcesRequired;
  public SVGStringList requiredExtensions;
  public SVGStringList requiredFeatures;
  public SVGStringList systemLanguage;
  public SVGElement targetElement;
  
  public native Object beginElement();

  public native Object beginElementAt(double offset);

  public native Object beginElementAt();

  public native Object endElement();

  public native Object endElementAt(double offset);

  public native Object endElementAt();

  public native double getCurrentTime();

  public native double getSimpleDuration();

  public native double getStartTime();

  public native boolean hasExtension(String extension);

  public native boolean hasExtension();

  @JsProperty
  public native void setRequiredExtensions(SVGStringList requiredExtensions);

  @JsProperty
  public native SVGStringList getRequiredExtensions();

  @JsProperty
  public native void setRequiredFeatures(SVGStringList requiredFeatures);

  @JsProperty
  public native SVGStringList getRequiredFeatures();

  @JsProperty
  public native void setSystemLanguage(SVGStringList systemLanguage);

  @JsProperty
  public native SVGStringList getSystemLanguage();

  @JsProperty
  public native void setExternalResourcesRequired(SVGAnimatedBoolean externalResourcesRequired);

  @JsProperty
  public native SVGAnimatedBoolean getExternalResourcesRequired();

}
