/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsFunction;
import elemental2.SQLResultSet;
import elemental2.SQLError;
import java.lang.Object;
import java.lang.String;
import elemental2.SQLTransaction.ExecuteSqlOpt_callback;
import elemental2.SQLTransaction.ExecuteSqlOpt_errorCallback;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class SQLTransaction {
  @JsFunction
  public interface ExecuteSqlOpt_callback {
    void onInvoke(SQLTransaction a, SQLResultSet b);

  }
  @JsFunction
  public interface ExecuteSqlOpt_errorCallback {
    boolean onInvoke(SQLTransaction a, SQLError b);

  }
  public native Object executeSql(String sqlStatement, Object[] queryArgs, ExecuteSqlOpt_callback callback, ExecuteSqlOpt_errorCallback errorCallback);

  public native Object executeSql(String sqlStatement);

  public native Object executeSql(String sqlStatement, Object[] queryArgs);

  public native Object executeSql(String sqlStatement, Object[] queryArgs, ExecuteSqlOpt_callback callback);

}
