/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import java.lang.String;
import java.lang.Object;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class RegExp {
  public static String $1;
  public static String $2;
  public static String $3;
  public static String $4;
  public static String $5;
  public static String $6;
  public static String $7;
  public static String $8;
  public static String $9;
  public static String input;
  public static String lastMatch;
  public static String lastParen;
  public static String leftContext;
  public static String rightContext;
  
  public boolean global;
  public boolean ignoreCase;
  public double lastIndex;
  public boolean multiline;
  public String source;
  
  public RegExp(Object pattern, Object flags) {}

  public RegExp() {}

  public RegExp(Object pattern) {}

  public native void compile(Object pattern, Object flags);

  public native void compile(Object pattern);

  public native String[] exec(Object str);

  public native boolean test(Object str);

  public native String toString();

}
