/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsFunction;
import java.lang.Object;
import elemental2.Reflect.ApplyTargetCallback;
import elemental2.Reflect.ConstructTargetType;
import elemental2.Reflect.ConstructOpt_newTargetType;
import elemental2.NativeObject;
import java.lang.String;
import elemental2.ObjectPropertyDescriptor;

@JsType(isNative = true, name = "Reflect", namespace = JsPackage.GLOBAL)
public class Reflect {
  @JsType
  public interface ConstructTargetType {
    
    
  }
  @JsType
  public interface ConstructOpt_newTargetType {
    
    
  }
  @JsFunction
  public interface ApplyTargetCallback<RESULT> {
    RESULT onInvoke(Object... a);

  }
  public static native <THIS, RESULT> RESULT apply(ApplyTargetCallback<RESULT> target, THIS thisArg, Object[] argList);

  public static native <TARGET> TARGET construct(ConstructTargetType target, Object[] argList, ConstructOpt_newTargetType newTarget);

  public static native <TARGET> TARGET construct(ConstructTargetType target, Object[] argList);

  public static native boolean defineProperty(NativeObject target, String propertyKey, NativeObject attributes);

  public static native boolean deleteProperty(NativeObject target, String propertyKey);

  public static native Object get(NativeObject target, String propertyKey, NativeObject receiver);

  public static native Object get(NativeObject target, String propertyKey);

  public static native ObjectPropertyDescriptor getOwnPropertyDescriptor(NativeObject target, String propertyKey);

  public static native NativeObject getPrototypeOf(NativeObject target);

  public static native boolean has(NativeObject target, String propertyKey);

  public static native boolean isExtensible(NativeObject target);

  public static native Object[] ownKeys(NativeObject target);

  public static native boolean preventExtensions(NativeObject target);

  public static native boolean set(NativeObject target, String propertyKey, Object value, NativeObject receiver);

  public static native boolean set(NativeObject target, String propertyKey, Object value);

  public static native boolean setPrototypeOf(NativeObject target, NativeObject proto);

  
}
