/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.AudioNode;
import java.lang.Object;
import elemental2.Uint8Array;
import elemental2.Float32Array;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class RealtimeAnalyserNode extends AudioNode {
  public double fftSize;
  public double frequencyBinCount;
  public double maxDecibels;
  public double minDecibels;
  public double smoothingTimeConstant;
  
  public native Object getByteFrequencyData(Uint8Array array);

  public native Object getByteTimeDomainData(Uint8Array array);

  public native Object getFloatFrequencyData(Float32Array array);

}
