/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.Node;
import elemental2.DocumentFragment;
import elemental2.ClientRect;
import elemental2.ClientRectList;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class Range {
  public double END_TO_END;
  public double END_TO_START;
  public double START_TO_END;
  public double START_TO_START;
  public boolean collapsed;
  public Node commonAncestorContainer;
  public Node endContainer;
  public double endOffset;
  public Node startContainer;
  public double startOffset;
  
  public native DocumentFragment cloneContents();

  public native Range cloneRange();

  public native void collapse(boolean toStart);

  public native double compareBoundaryPoints(double how, Range sourceRange);

  public native double deleteContents();

  public native void detach();

  public native DocumentFragment extractContents();

  public native ClientRect getBoundingClientRect();

  public native ClientRectList getClientRects();

  public native DocumentFragment insertNode(Node newNode);

  public native void selectNode(Node refNode);

  public native void selectNodeContents(Node refNode);

  public native void setEnd(Node refNode, double offset);

  public native void setEndAfter(Node refNode);

  public native void setEndBefore(Node refNode);

  public native void setStart(Node refNode, double offset);

  public native void setStartAfter(Node refNode);

  public native void setStartBefore(Node refNode);

  public native void surroundContents(Node newParent);

}
