/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.EventTarget;
import jsinterop.annotations.JsProperty;
import elemental2.RTCPeerConnection.RTCPeerConnection_InstanceConfigurationIceServersType;
import java.lang.String;
import elemental2.RTCPeerConnection.UpdateIceConfigurationIceServersType;
import jsinterop.annotations.JsFunction;
import elemental2.Event;
import java.lang.Object;
import elemental2.RTCSessionDescription;
import elemental2.RTCStatsResponse;
import elemental2.MediaStreamTrack;
import elemental2.MediaStreamEvent;
import elemental2.RTCPeerConnectionIceEvent;
import elemental2.RTCPeerConnection.OnaddstreamCallback;
import elemental2.RTCPeerConnection.OndatachannelCallback;
import elemental2.RTCPeerConnection.OnicecandidateCallback;
import elemental2.RTCPeerConnection.OniceconnectionstatechangeCallback;
import elemental2.RTCPeerConnection.OnnegotiationneededCallback;
import elemental2.RTCPeerConnection.OnremovestreamCallback;
import elemental2.RTCPeerConnection.OnsignalingstatechangeCallback;
import elemental2.RTCPeerConnection.RTCPeerConnection_InstanceConfigurationType;
import elemental2.NativeObject;
import elemental2.RTCPeerConnection.AddEventListenerListenerCallback;
import elemental2.EventListener;
import elemental2.RTCIceCandidate;
import elemental2.MediaStream;
import elemental2.RTCPeerConnection.CreateAnswerSuccessCallback;
import elemental2.RTCPeerConnection.CreateAnswerFailureCallback;
import elemental2.RTCDataChannel;
import elemental2.RTCPeerConnection.CreateDataChannelDataChannelDictType;
import elemental2.RTCPeerConnection.CreateOfferSuccessCallback;
import elemental2.RTCPeerConnection.CreateOfferFailureCallback;
import elemental2.RTCPeerConnection.GetStatsSuccessCallback;
import elemental2.RTCPeerConnection.RemoveEventListenerListenerCallback;
import elemental2.RTCPeerConnection.SetLocalDescriptionSuccessCallback;
import elemental2.RTCPeerConnection.SetLocalDescriptionFailureCallback;
import elemental2.RTCPeerConnection.SetRemoteDescriptionSuccessCallback;
import elemental2.RTCPeerConnection.SetRemoteDescriptionFailureCallback;
import elemental2.RTCPeerConnection.UpdateIceConfigurationType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class RTCPeerConnection implements EventTarget {
  @JsType
  public interface RTCPeerConnection_InstanceConfigurationType {
    @JsProperty
    void setIceServers(RTCPeerConnection_InstanceConfigurationIceServersType[] iceServers);

    @JsProperty
    RTCPeerConnection_InstanceConfigurationIceServersType[] getIceServers();

  }
  @JsType
  public interface RTCPeerConnection_InstanceConfigurationIceServersType {
    @JsProperty
    void setUrl(String url);

    @JsProperty
    String getUrl();

  }
  @JsType
  public interface CreateDataChannelDataChannelDictType {
    @JsProperty
    void setReliable(boolean reliable);

    @JsProperty
    boolean isReliable();

  }
  @JsType
  public interface UpdateIceConfigurationType {
    @JsProperty
    void setIceServers(UpdateIceConfigurationIceServersType[] iceServers);

    @JsProperty
    UpdateIceConfigurationIceServersType[] getIceServers();

  }
  @JsType
  public interface UpdateIceConfigurationIceServersType {
    @JsProperty
    void setUrl(String url);

    @JsProperty
    String getUrl();

  }
  @JsFunction
  public interface AddEventListenerListenerCallback {
    boolean onInvoke(Event a);

  }
  @JsFunction
  public interface CreateAnswerSuccessCallback {
    Object onInvoke(RTCSessionDescription a);

  }
  @JsFunction
  public interface CreateAnswerFailureCallback {
    Object onInvoke(String a);

  }
  @JsFunction
  public interface CreateOfferSuccessCallback {
    Object onInvoke(RTCSessionDescription a);

  }
  @JsFunction
  public interface CreateOfferFailureCallback {
    Object onInvoke(String a);

  }
  @JsFunction
  public interface GetStatsSuccessCallback {
    Object onInvoke(RTCStatsResponse a, MediaStreamTrack b);

  }
  @JsFunction
  public interface OnaddstreamCallback {
    Object onInvoke(MediaStreamEvent a);

  }
  @JsFunction
  public interface OndatachannelCallback {
    Object onInvoke(Object a);

  }
  @JsFunction
  public interface OnicecandidateCallback {
    Object onInvoke(RTCPeerConnectionIceEvent a);

  }
  @JsFunction
  public interface OniceconnectionstatechangeCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnnegotiationneededCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnremovestreamCallback {
    Object onInvoke(MediaStreamEvent a);

  }
  @JsFunction
  public interface OnsignalingstatechangeCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface RemoveEventListenerListenerCallback {
    boolean onInvoke(Event a);

  }
  @JsFunction
  public interface SetLocalDescriptionSuccessCallback {
    Object onInvoke();

  }
  @JsFunction
  public interface SetLocalDescriptionFailureCallback {
    Object onInvoke(String a);

  }
  @JsFunction
  public interface SetRemoteDescriptionSuccessCallback {
    Object onInvoke();

  }
  @JsFunction
  public interface SetRemoteDescriptionFailureCallback {
    Object onInvoke(String a);

  }
  public String iceConnectionState;
  public String iceGatheringState;
  public RTCSessionDescription localDescription;
  public OnaddstreamCallback onaddstream;
  public OndatachannelCallback ondatachannel;
  public OnicecandidateCallback onicecandidate;
  public OniceconnectionstatechangeCallback oniceconnectionstatechange;
  public OnnegotiationneededCallback onnegotiationneeded;
  public OnremovestreamCallback onremovestream;
  public OnsignalingstatechangeCallback onsignalingstatechange;
  public RTCSessionDescription remoteDescription;
  public String signalingState;
  
  public RTCPeerConnection(RTCPeerConnection_InstanceConfigurationType configuration, NativeObject constraints) {}

  public RTCPeerConnection(RTCPeerConnection_InstanceConfigurationType configuration) {}

  public native void addEventListener(String type, AddEventListenerListenerCallback listener, boolean useCapture);

  public native void addEventListener(String type, EventListener listener, boolean useCapture);

  public native void addEventListener(String type, AddEventListenerListenerCallback listener);

  public native void addEventListener(String type, EventListener listener);

  public native Object addIceCandidate(RTCIceCandidate candidate);

  public native Object addStream(MediaStream stream, NativeObject constraints);

  public native Object addStream(MediaStream stream);

  public native Object close();

  public native Object createAnswer(CreateAnswerSuccessCallback successCallback, CreateAnswerFailureCallback failureCallback, NativeObject constraints);

  public native Object createAnswer(CreateAnswerSuccessCallback successCallback);

  public native Object createAnswer(CreateAnswerSuccessCallback successCallback, CreateAnswerFailureCallback failureCallback);

  public native RTCDataChannel createDataChannel(String label, CreateDataChannelDataChannelDictType dataChannelDict);

  public native RTCDataChannel createDataChannel(String label);

  public native Object createOffer(CreateOfferSuccessCallback successCallback, CreateOfferFailureCallback failureCallback, NativeObject constraints);

  public native Object createOffer(CreateOfferSuccessCallback successCallback);

  public native Object createOffer(CreateOfferSuccessCallback successCallback, CreateOfferFailureCallback failureCallback);

  public native boolean dispatchEvent(Event evt);

  public native MediaStream[] getLocalStreams();

  public native MediaStream[] getRemoteStreams();

  public native Object getStats(GetStatsSuccessCallback successCallback, MediaStreamTrack selector);

  public native Object getStats(GetStatsSuccessCallback successCallback);

  public native MediaStream getStreamById(String streamId);

  public native void removeEventListener(String type, RemoveEventListenerListenerCallback listener, boolean useCapture);

  public native void removeEventListener(String type, EventListener listener, boolean useCapture);

  public native void removeEventListener(String type, RemoveEventListenerListenerCallback listener);

  public native void removeEventListener(String type, EventListener listener);

  public native Object removeStream(MediaStream stream);

  public native Object setLocalDescription(RTCSessionDescription description, SetLocalDescriptionSuccessCallback successCallback, SetLocalDescriptionFailureCallback failureCallback);

  public native Object setLocalDescription(RTCSessionDescription description);

  public native Object setLocalDescription(RTCSessionDescription description, SetLocalDescriptionSuccessCallback successCallback);

  public native Object setRemoteDescription(RTCSessionDescription description, SetRemoteDescriptionSuccessCallback successCallback, SetRemoteDescriptionFailureCallback failureCallback);

  public native Object setRemoteDescription(RTCSessionDescription description);

  public native Object setRemoteDescription(RTCSessionDescription description, SetRemoteDescriptionSuccessCallback successCallback);

  public native Object updateIce(UpdateIceConfigurationType configuration, NativeObject constraints);

  public native Object updateIce();

  public native Object updateIce(UpdateIceConfigurationType configuration);

  public native void addEventListener(String type, elemental2.EventTarget.AddEventListenerListenerCallback listener, boolean useCapture);

  public native void removeEventListener(String type, elemental2.EventTarget.RemoveEventListenerListenerCallback listener, boolean useCapture);

}
