/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsFunction;
import java.lang.Object;
import elemental2.Event;
import elemental2.MessageEvent;
import jsinterop.annotations.JsProperty;
import java.lang.String;
import elemental2.RTCDataChannel.OncloseCallback;
import elemental2.RTCDataChannel.OnerrorCallback;
import elemental2.RTCDataChannel.OnmessageCallback;
import elemental2.RTCDataChannel.OnopenCallback;
import elemental2.ArrayBufferView;
import elemental2.Blob;
import elemental2.ArrayBuffer;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public interface RTCDataChannel {
  @JsFunction
  public interface OncloseCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnerrorCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnmessageCallback<Object> {
    Object onInvoke(MessageEvent<Object> a);

  }
  @JsFunction
  public interface OnopenCallback {
    Object onInvoke(Event a);

  }
  @JsProperty
  void setBinaryType(String binaryType);

  @JsProperty
  String getBinaryType();

  @JsProperty
  void setBufferedAmount(double bufferedAmount);

  @JsProperty
  double getBufferedAmount();

  Object close();

  @JsProperty
  void setLabel(String label);

  @JsProperty
  String getLabel();

  @JsProperty
  void setOnclose(OncloseCallback onclose);

  @JsProperty
  OncloseCallback getOnclose();

  @JsProperty
  void setOnerror(OnerrorCallback onerror);

  @JsProperty
  OnerrorCallback getOnerror();

  @JsProperty
  void setOnmessage(OnmessageCallback<Object> onmessage);

  @JsProperty
  OnmessageCallback getOnmessage();

  @JsProperty
  void setOnopen(OnopenCallback onopen);

  @JsProperty
  OnopenCallback getOnopen();

  @JsProperty
  void setReadyState(String readyState);

  @JsProperty
  String getReadyState();

  @JsProperty
  void setReliable(boolean reliable);

  @JsProperty
  boolean isReliable();

  Object send(ArrayBufferView data);

  Object send(String data);

  Object send(Blob data);

  Object send(ArrayBuffer data);

}
