/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import elemental2.Promise;
import elemental2.PushSubscription;
import elemental2.PushManager.SubscribeOpt_optionsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class PushManager {
  @JsType
  public interface SubscribeOpt_optionsType {
    @JsProperty
    void setUserVisibleOnly(boolean userVisibleOnly);

    @JsProperty
    boolean isUserVisibleOnly();

  }
  public native Promise<PushSubscription> getSubscription();

  public native Promise<PushSubscription> subscribe(SubscribeOpt_optionsType options);

  public native Promise<PushSubscription> subscribe();

}
