/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.ExtendableEvent;
import jsinterop.annotations.JsProperty;
import elemental2.PushMessageData;
import java.lang.String;
import elemental2.PushEvent.PushEvent_InstanceOpt_eventInitDictType;
import elemental2.ExtendableEvent.ExtendableEvent_InstanceOpt_eventInitDictType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class PushEvent extends ExtendableEvent {
  @JsType
  public interface PushEvent_InstanceOpt_eventInitDictType {
    @JsProperty
    void setBubbles(boolean bubbles);

    @JsProperty
    boolean isBubbles();

    @JsProperty
    void setCancelable(boolean cancelable);

    @JsProperty
    boolean isCancelable();

  }
  public PushMessageData data;
  
  public PushEvent(String type, PushEvent_InstanceOpt_eventInitDictType eventInitDict) {
    // This call is only there for java compilation purpose.
    super((String) null, (ExtendableEvent_InstanceOpt_eventInitDictType) null);
  }

  public PushEvent(String type) {
    // This call is only there for java compilation purpose.
    super((String) null, (ExtendableEvent_InstanceOpt_eventInitDictType) null);
  }

  
}
