/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.IThenable;
import jsinterop.annotations.JsProperty;
import java.lang.Object;
import jsinterop.annotations.JsFunction;
import elemental2.Promise.ResolverACallback;
import elemental2.Promise.ResolverBCallback;
import elemental2.Iterable;
import elemental2.Promise.ResolverCallback;
import jsinterop.annotations.JsMethod;
import elemental2.Promise.CatchOnRejectedCallback;
import elemental2.Promise.ThenOpt_onFulfilledCallback;
import elemental2.Promise.ThenOpt_onRejectedCallback;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class Promise<TYPE> implements IThenable<TYPE> {
  @JsType
  public interface Promise_InstanceResolverAAType {
    @JsProperty
    void setThen(Object then);

    @JsProperty
    Object getThen();

  }
  @JsFunction
  public interface ResolverCallback {
    Object onInvoke(ResolverACallback a, ResolverBCallback b);

  }
  @JsFunction
  public interface ResolverACallback {
    Object onInvoke(/* TYPE | IThenable | Promise_InstanceResolverAAType */ Object a);

  }
  @JsFunction
  public interface ResolverBCallback {
    Object onInvoke(Object a);

  }
  @JsFunction
  public interface CatchOnRejectedCallback<RESULT> {
    RESULT onInvoke(Object a);

  }
  @JsFunction
  public interface ThenOpt_onFulfilledCallback<TYPE, VALUE> {
    VALUE onInvoke(TYPE a);

  }
  @JsFunction
  public interface ThenOpt_onRejectedCallback {
    Object onInvoke(Object a);

  }
  public static native <T> Promise<T[]> all(Iterable</* T | Promise */ Object> iterable);

  public static native <T> Promise<T[]> all(/* T | Promise */ Object[] iterable);

  public static native <T> Promise<T> race(Iterable<T> iterable);

  public static native <T> Promise<T> race(T[] iterable);

  public static native Promise<Object> reject(Object error);

  public static native Promise<Object> reject();

  public static native <VALUE, RESULT> RESULT resolve(VALUE value);

  public static native <RESULT> RESULT resolve();

  public Promise(ResolverCallback resolver) {}

  @JsMethod(name = "catch")
  public native <RESULT> Promise<RESULT> catch_(CatchOnRejectedCallback<RESULT> onRejected);

  public native <VALUE, RESULT> RESULT then(ThenOpt_onFulfilledCallback<TYPE, VALUE> onFulfilled, ThenOpt_onRejectedCallback onRejected);

  public native <RESULT> RESULT then();

  public native <VALUE, RESULT> RESULT then(ThenOpt_onFulfilledCallback<TYPE, VALUE> onFulfilled);

  public native <VALUE, RESULT> RESULT then(elemental2.IThenable.ThenOpt_onFulfilledCallback<TYPE, VALUE> onFulfilled, elemental2.IThenable.ThenOpt_onRejectedCallback onRejected);

  public native <VALUE, RESULT> RESULT then(elemental2.IThenable.ThenOpt_onFulfilledCallback<TYPE, VALUE> onFulfilled);

}
