/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.PerformanceMemory;
import elemental2.PerformanceNavigation;
import elemental2.PerformanceTiming;
import java.lang.Object;
import java.lang.String;
import elemental2.PerformanceEntry;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class Performance {
  public PerformanceMemory memory;
  public PerformanceNavigation navigation;
  public PerformanceTiming timing;
  
  public native Object clearMarks(String markName);

  public native Object clearMarks();

  public native Object clearMeasures(String measureName);

  public native Object clearMeasures();

  public native void clearResourceTimings();

  public native PerformanceEntry[] getEntries();

  public native PerformanceEntry[] getEntriesByName(String name, String entryType);

  public native PerformanceEntry[] getEntriesByName(String name);

  public native PerformanceEntry[] getEntriesByType(String entryType);

  public native Object mark(String markName);

  public native Object measure(String measureName, String startMark, String endMark);

  public native Object measure(String measureName);

  public native Object measure(String measureName, String startMark);

  public native double now();

  public native Object setResourceTimingBufferSize(double maxSize);

  public native void webkitClearResourceTimings();

  public native double webkitNow();

}
