/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.AudioNode;
import elemental2.AudioParam;
import elemental2.EventListener;
import java.lang.String;
import java.lang.Object;
import elemental2.PeriodicWave;
import elemental2.WaveTable;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class OscillatorNode extends AudioNode {
  public AudioParam detune;
  public AudioParam frequency;
  public EventListener onended;
  public double playbackState;
  public String type;
  
  public native Object setPeriodicWave(PeriodicWave a);

  public native Object setWaveTable(WaveTable a);

  public native Object start(double a);

  public native Object stop(double a);

}
