/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsFunction;
import java.lang.Object;
import elemental2.ObjectPropertyDescriptor.GetCallback;
import elemental2.ObjectPropertyDescriptor.SetCallback;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class ObjectPropertyDescriptor {
  @JsFunction
  public interface GetCallback {
    Object onInvoke();

  }
  @JsFunction
  public interface SetCallback {
    void onInvoke(Object a);

  }
  public boolean configurable;
  public boolean enumerable;
  public GetCallback get;
  public SetCallback set;
  public Object value;
  public boolean writable;
  
  
}
