/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.EventTarget;
import jsinterop.annotations.JsFunction;
import elemental2.Event;
import elemental2.NamedNodeMap;
import elemental2.Attr;
import java.lang.String;
import elemental2.NodeList;
import elemental2.Document;
import elemental2.Node.AddEventListenerListenerCallback;
import elemental2.EventListener;
import elemental2.NativeObject;
import elemental2.Element;
import elemental2.Node.RemoveEventListenerListenerCallback;
import elemental2.UserDataHandler;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class Node implements EventTarget {
  @JsFunction
  public interface AddEventListenerListenerCallback {
    boolean onInvoke(Event a);

  }
  @JsFunction
  public interface RemoveEventListenerListenerCallback {
    boolean onInvoke(Event a);

  }
  public static double ATTRIBUTE_NODE;
  public static double CDATA_SECTION_NODE;
  public static double COMMENT_NODE;
  public static double DOCUMENT_FRAGMENT_NODE;
  public static double DOCUMENT_NODE;
  public static double DOCUMENT_POSITION_CONTAINED_BY;
  public static double DOCUMENT_POSITION_CONTAINS;
  public static double DOCUMENT_POSITION_DISCONNECTED;
  public static double DOCUMENT_POSITION_FOLLOWING;
  public static double DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC;
  public static double DOCUMENT_POSITION_PRECEDING;
  public static double DOCUMENT_TYPE_NODE;
  public static double ELEMENT_NODE;
  public static double ENTITY_NODE;
  public static double ENTITY_REFERENCE_NODE;
  public static double NOTATION_NODE;
  public static double PROCESSING_INSTRUCTION_NODE;
  public static double TEXT_NODE;
  public static double XPATH_NAMESPACE_NODE;
  
  public NamedNodeMap<Attr> attributes;
  public String baseURI;
  public NodeList<Node> childNodes;
  public Node firstChild;
  public Node lastChild;
  public String localName;
  public String namespaceURI;
  public Node nextSibling;
  public String nodeName;
  public double nodeType;
  public String nodeValue;
  public Document ownerDocument;
  public Node parentNode;
  public String prefix;
  public Node previousSibling;
  public String textContent;
  
  public native void addEventListener(String type, AddEventListenerListenerCallback listener, boolean useCapture);

  public native void addEventListener(String type, EventListener listener, boolean useCapture);

  public native void addEventListener(String type, AddEventListenerListenerCallback listener);

  public native void addEventListener(String type, EventListener listener);

  public native Node appendChild(Node newChild);

  public native Node cloneNode(boolean deep);

  public native double compareDocumentPosition(Node other);

  public native boolean contains(Node n);

  public native boolean dispatchEvent(Event evt);

  public native NativeObject getFeature(String feature, String version);

  public native NativeObject getUserData(String key);

  public native boolean hasAttributes();

  public native boolean hasChildNodes();

  public native Node insertBefore(Node newChild, Node refChild);

  public native boolean isDefaultNamespace(String namespaceURI);

  public native boolean isEqualNode(Node arg);

  public native boolean isSameNode(Node other);

  public native boolean isSupported(String feature, String version);

  public native String lookupNamespaceURI(String prefix);

  public native String lookupPrefix(String namespaceURI);

  public native void normalize();

  public native Element querySelector(String query);

  public native NodeList<Element> querySelectorAll(String query);

  public native Node removeChild(Node oldChild);

  public native void removeEventListener(String type, RemoveEventListenerListenerCallback listener, boolean useCapture);

  public native void removeEventListener(String type, EventListener listener, boolean useCapture);

  public native void removeEventListener(String type, RemoveEventListenerListenerCallback listener);

  public native void removeEventListener(String type, EventListener listener);

  public native Node replaceChild(Node newChild, Node oldChild);

  public native NativeObject setUserData(NativeObject key, NativeObject data, UserDataHandler handler);

  public native void addEventListener(String type, elemental2.EventTarget.AddEventListenerListenerCallback listener, boolean useCapture);

  public native void removeEventListener(String type, elemental2.EventTarget.RemoveEventListenerListenerCallback listener, boolean useCapture);

}
