/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import elemental2.Navigator.RequestMediaKeySystemAccessSupportedConfigurationsAudioCapabilitiesType;
import java.lang.String;
import elemental2.Navigator.RequestMediaKeySystemAccessSupportedConfigurationsVideoCapabilitiesType;
import jsinterop.annotations.JsFunction;
import java.lang.Object;
import elemental2.MediaStream;
import elemental2.NavigatorUserMediaError;
import elemental2.Geolocation;
import elemental2.MediaDevices;
import elemental2.MimeTypeArray;
import elemental2.Permissions;
import elemental2.PluginArray;
import elemental2.ServiceWorkerContainer;
import elemental2.Promise;
import elemental2.MediaKeySystemAccess;
import elemental2.Navigator.RequestMediaKeySystemAccessSupportedConfigurationsType;
import elemental2.NativeObject;
import elemental2.Navigator.WebkitGetUserMediaSuccessCallback;
import elemental2.Navigator.WebkitGetUserMediaErrorCallback;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class Navigator {
  @JsType
  public interface RequestMediaKeySystemAccessSupportedConfigurationsType {
    @JsProperty
    void setAudioCapabilities(RequestMediaKeySystemAccessSupportedConfigurationsAudioCapabilitiesType[] audioCapabilities);

    @JsProperty
    RequestMediaKeySystemAccessSupportedConfigurationsAudioCapabilitiesType[] getAudioCapabilities();

    @JsProperty
    void setDistinctiveIdentifier(String distinctiveIdentifier);

    @JsProperty
    String getDistinctiveIdentifier();

    @JsProperty
    void setInitDataTypes(String[] initDataTypes);

    @JsProperty
    String[] getInitDataTypes();

    @JsProperty
    void setPersistentState(String persistentState);

    @JsProperty
    String getPersistentState();

    @JsProperty
    void setVideoCapabilities(RequestMediaKeySystemAccessSupportedConfigurationsVideoCapabilitiesType[] videoCapabilities);

    @JsProperty
    RequestMediaKeySystemAccessSupportedConfigurationsVideoCapabilitiesType[] getVideoCapabilities();

  }
  @JsType
  public interface RequestMediaKeySystemAccessSupportedConfigurationsAudioCapabilitiesType {
    @JsProperty
    void setContentType(String contentType);

    @JsProperty
    String getContentType();

    @JsProperty
    void setRobustness(String robustness);

    @JsProperty
    String getRobustness();

  }
  @JsType
  public interface RequestMediaKeySystemAccessSupportedConfigurationsVideoCapabilitiesType {
    @JsProperty
    void setContentType(String contentType);

    @JsProperty
    String getContentType();

    @JsProperty
    void setRobustness(String robustness);

    @JsProperty
    String getRobustness();

  }
  @JsFunction
  public interface WebkitGetUserMediaSuccessCallback {
    Object onInvoke(MediaStream a);

  }
  @JsFunction
  public interface WebkitGetUserMediaErrorCallback {
    Object onInvoke(NavigatorUserMediaError a);

  }
  public String appCodeName;
  public String appName;
  public String appVersion;
  public boolean cookieEnabled;
  public Geolocation geolocation;
  public String language;
  public MediaDevices mediaDevices;
  public MimeTypeArray mimeTypes;
  public boolean onLine;
  public Permissions permissions;
  public String platform;
  public PluginArray plugins;
  public String product;
  public ServiceWorkerContainer serviceWorker;
  public String userAgent;
  
  public native boolean javaEnabled();

  public native Object registerContentHandler(String mimeType, String url, String title);

  public native Object registerProtocolHandler(String scheme, String url, String title);

  public native Promise<MediaKeySystemAccess> requestMediaKeySystemAccess(String keySystem, RequestMediaKeySystemAccessSupportedConfigurationsType[] supportedConfigurations);

  public native boolean taintEnabled();

  public native Object unregisterContentHandler(String mimeType, String url);

  public native Object unregisterProtocolHandler(String scheme, String url);

  public native Object webkitGetUserMedia(NativeObject constraints, WebkitGetUserMediaSuccessCallback successCallback, WebkitGetUserMediaErrorCallback errorCallback);

  public native Object webkitGetUserMedia(NativeObject constraints, WebkitGetUserMediaSuccessCallback successCallback);

}
