/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsFunction;
import java.lang.Object;
import java.lang.String;
import elemental2.ITemplateArray;
import elemental2.NativeObject;
import elemental2.NativeString.ReplaceStrCallback;
import elemental2.RegExp;

@JsType(isNative = true, name = "String", namespace = JsPackage.GLOBAL)
public class NativeString {
  @JsFunction
  public interface ReplaceStrCallback {
    Object onInvoke(Object... a);

  }
  public static native String fromCharCode(double... var_args);

  public static native String fromCodePoint(double codePoint, double... var_args);

  public static native String raw(ITemplateArray template, Object... var_args);

  public double length;
  
  public NativeString(Object str) {}

  public NativeString() {}

  public native String anchor();

  public native String big();

  public native String blink();

  public native String bold();

  public native String charAt(double index);

  public native double charCodeAt(double index);

  public native double charCodeAt();

  public native double codePointAt(double index);

  public native String concat(Object... var_args);

  public native boolean endsWith(String searchString, double position);

  public native boolean endsWith(String searchString);

  public native String fixed();

  public native String fontcolor(String color);

  public native String fontsize(double size);

  public native boolean includes(String searchString, double position);

  public native boolean includes(String searchString);

  public native double indexOf(String searchValue, double fromIndex);

  public native double indexOf(String searchValue);

  public native String italics();

  public native double lastIndexOf(String searchValue, double fromIndex);

  public native double lastIndexOf(String searchValue);

  public native String link(String hrefAttribute);

  public native double localeCompare(String compareString, String[] locales, NativeObject options);

  public native double localeCompare(String compareString);

  public native double localeCompare(String compareString, String locales, NativeObject options);

  public native double localeCompare(String compareString, String[] locales);

  public native double localeCompare(String compareString, String locales);

  public native String[] match(Object regexp);

  public native String normalize(String form);

  public native String normalize();

  public native String quote();

  public native String repeat(double count);

  public native String replace(String regex, ReplaceStrCallback str, String flags);

  public native String replace(RegExp regex, ReplaceStrCallback str, String flags);

  public native String replace(RegExp regex, String str, String flags);

  public native String replace(String regex, String str, String flags);

  public native String replace(String regex, ReplaceStrCallback str);

  public native String replace(RegExp regex, ReplaceStrCallback str);

  public native String replace(RegExp regex, String str);

  public native String replace(String regex, String str);

  public native double search(String regexp);

  public native double search(RegExp regexp);

  public native String slice(double begin, double end);

  public native String slice(double begin);

  public native String small();

  public native String[] split(Object separator, double limit);

  public native String[] split();

  public native String[] split(Object separator);

  public native boolean startsWith(String searchString, double position);

  public native boolean startsWith(String searchString);

  public native String strike();

  public native String sub();

  public native String substr(double start, double length);

  public native String substr(double start);

  public native String substring(double start, double end);

  public native String substring(double start);

  public native String sup();

  public native String toLocaleLowerCase();

  public native String toLocaleUpperCase();

  public native String toLowerCase();

  public native String toSource();

  public native String toString();

  public native String toUpperCase();

  public native String trim();

  public native String trimLeft();

  public native String trimRight();

  public native String valueOf();

}
