/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsFunction;
import java.lang.Object;
import java.lang.String;
import elemental2.ObjectPropertyDescriptor;
import elemental2.NativeObject.ObserveCallback;
import elemental2.NativeObject.UnobserveCallback;
import elemental2.NativeObject.ObserveCallback0;
import elemental2.NativeObject.UnobserveCallback0;
import elemental2.NativeObject.___defineGetter__FunCallback;
import elemental2.NativeObject.___defineSetter__FunCallback;
import elemental2.NativeObject.___lookupGetter__Callback;
import elemental2.NativeObject.___lookupSetter__Callback;
import elemental2.NativeObject.___noSuchMethod__FunCallback;
import elemental2.NativeObject.WatchHandlerCallback;

@JsType(isNative = true, name = "Object", namespace = JsPackage.GLOBAL)
public class NativeObject {
  @JsFunction
  public interface ObserveCallback {
    Object onInvoke(Object... a);

  }
  @JsFunction
  public interface UnobserveCallback {
    Object onInvoke(Object... a);

  }
  @JsFunction
  public interface ObserveCallback0 {
    Object onInvoke(Object... a);

  }
  @JsFunction
  public interface UnobserveCallback0 {
    Object onInvoke(Object... a);

  }
  @JsFunction
  public interface ___defineGetter__FunCallback {
    Object onInvoke(Object... a);

  }
  @JsFunction
  public interface ___defineSetter__FunCallback {
    Object onInvoke(Object... a);

  }
  @JsFunction
  public interface ___lookupGetter__Callback {
    Object onInvoke(Object... a);

  }
  @JsFunction
  public interface ___lookupSetter__Callback {
    Object onInvoke(Object... a);

  }
  @JsFunction
  public interface ___noSuchMethod__FunCallback {
    Object onInvoke(Object... a);

  }
  @JsFunction
  public interface WatchHandlerCallback {
    Object onInvoke(Object... a);

  }
  public static native NativeObject assign(NativeObject target, NativeObject... var_args);

  public static native NativeObject create(NativeObject proto, NativeObject properties);

  public static native NativeObject create(NativeObject proto);

  public static native NativeObject defineProperties(NativeObject obj, NativeObject props);

  public static native NativeObject defineProperty(NativeObject obj, String prop, NativeObject descriptor);

  public static native <T> T freeze(T obj);

  public static native ObjectPropertyDescriptor getOwnPropertyDescriptor(NativeObject obj, String prop);

  public static native String[] getOwnPropertyNames(NativeObject obj);

  public static native Object[] getOwnPropertySymbols(NativeObject obj);

  public static native NativeObject getPrototypeOf(NativeObject obj);

  public static native boolean is(Object a, Object b);

  public static native boolean isExtensible(NativeObject obj);

  public static native boolean isFrozen(NativeObject obj);

  public static native boolean isSealed(NativeObject obj);

  public static native String[] keys(NativeObject obj);

  public static native Object observe(NativeObject object, ObserveCallback callback, String[] acceptList);

  public static native Object observe(NativeObject object, ObserveCallback callback);

  public static native <T> T preventExtensions(T obj);

  public static native <T> T seal(T obj);

  public static native NativeObject setPrototypeOf(NativeObject obj, Object proto);

  public static native Object unobserve(NativeObject object, UnobserveCallback callback);

  public static native Object observe(NativeObject object, ObserveCallback0 callback, String[] acceptList);

  public static native Object observe(NativeObject object, ObserveCallback0 callback);

  public static native Object unobserve(NativeObject object, UnobserveCallback0 callback);

  public NativeObject ___parent__;
  public NativeObject ___proto__;
  
  public NativeObject(Object value) {}

  public NativeObject() {}

  public native Object ___defineGetter__(String sprop, ___defineGetter__FunCallback fun);

  public native Object ___defineSetter__(String sprop, ___defineSetter__FunCallback fun);

  public native ___lookupGetter__Callback ___lookupGetter__(String sprop);

  public native ___lookupSetter__Callback ___lookupSetter__(String sprop);

  public native Object ___noSuchMethod__(___noSuchMethod__FunCallback fun);

  public native boolean hasOwnProperty(Object propertyName);

  public native boolean isPrototypeOf(NativeObject other);

  public native boolean propertyIsEnumerable(String propertyName);

  public native Object toJSON(String key);

  public native Object toJSON();

  public native String toLocaleString();

  public native String toSource();

  public native String toString();

  public native Object unwatch(String prop);

  public native Object valueOf();

  public native Object watch(String prop, WatchHandlerCallback handler);

}
