/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import java.lang.String;
import java.lang.Object;
import elemental2.NativeObject;

@JsType(isNative = true, name = "Number", namespace = JsPackage.GLOBAL)
public class NativeNumber {
  public static double EPSILON;
  public static double MAX_SAFE_INTEGER;
  public static double MAX_VALUE;
  public static double MIN_SAFE_INTEGER;
  public static double MIN_VALUE;
  public static double NEGATIVE_INFINITY;
  public static double NaN;
  public static double POSITIVE_INFINITY;
  
  public static native boolean isFinite(double value);

  public static native boolean isInteger(double value);

  public static native boolean isNaN(double value);

  public static native boolean isSafeInteger(double value);

  public static native double parseFloat(String string);

  public static native double parseInt(String string, double radix);

  public NativeNumber(Object value) {}

  public NativeNumber() {}

  public native String toExponential(double fractionDigits);

  public native String toExponential();

  public native String toFixed(Object digits);

  public native String toFixed();

  public native String toLocaleString(String[] locales, NativeObject options);

  public native String toLocaleString();

  public native String toLocaleString(String locales, NativeObject options);

  public native String toLocaleString(String[] locales);

  public native String toLocaleString(String locales);

  public native String toPrecision(double precision);

  public native String toPrecision();

  public native String toString(NativeNumber radix);

  public native String toString();

  public native String toString(double radix);

}
