/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import java.lang.String;
import jsinterop.annotations.JsFunction;
import java.lang.Object;
import elemental2.MutationRecord;
import elemental2.MutationObserver.Callback;
import elemental2.Node;
import elemental2.MutationObserver.ObserveOptionsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class MutationObserver {
  @JsType
  public interface ObserveOptionsType {
    @JsProperty
    void setAttributeFilter(String[] attributeFilter);

    @JsProperty
    String[] getAttributeFilter();

    @JsProperty
    void setAttributeOldValue(boolean attributeOldValue);

    @JsProperty
    boolean isAttributeOldValue();

    @JsProperty
    void setAttributes(boolean attributes);

    @JsProperty
    boolean isAttributes();

    @JsProperty
    void setCharacterData(boolean characterData);

    @JsProperty
    boolean isCharacterData();

    @JsProperty
    void setCharacterDataOldValue(boolean characterDataOldValue);

    @JsProperty
    boolean isCharacterDataOldValue();

    @JsProperty
    void setChildList(boolean childList);

    @JsProperty
    boolean isChildList();

    @JsProperty
    void setSubtree(boolean subtree);

    @JsProperty
    boolean isSubtree();

  }
  @JsFunction
  public interface Callback {
    Object onInvoke(MutationRecord[] a, MutationObserver b);

  }
  public MutationObserver(Callback callback) {}

  public native Object disconnect();

  public native Object observe(Node target, ObserveOptionsType options);

  public native Object observe(Node target);

}
