/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.EventTarget;
import jsinterop.annotations.JsFunction;
import java.lang.Object;
import elemental2.Event;
import jsinterop.annotations.JsMethod;
import jsinterop.annotations.JsProperty;
import java.lang.String;
import elemental2.MediaStreamTrack.OnendedCallback;
import elemental2.MediaStreamTrack.OnmuteCallback;
import elemental2.MediaStreamTrack.OnunmuteCallback;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public interface MediaStreamTrack extends EventTarget {
  @JsFunction
  public interface OnendedCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnmuteCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnunmuteCallback {
    Object onInvoke(Event a);

  }
  @JsMethod(name = "clone")
  MediaStreamTrack clone_();

  @JsProperty
  void setEnabled(boolean enabled);

  @JsProperty
  boolean isEnabled();

  @JsProperty
  void setId(String id);

  @JsProperty
  String getId();

  @JsProperty
  void setKind(String kind);

  @JsProperty
  String getKind();

  @JsProperty
  void setLabel(String label);

  @JsProperty
  String getLabel();

  @JsProperty
  void setMuted(boolean muted);

  @JsProperty
  boolean isMuted();

  @JsProperty
  void setOnended(OnendedCallback onended);

  @JsProperty
  OnendedCallback getOnended();

  @JsProperty
  void setOnmute(OnmuteCallback onmute);

  @JsProperty
  OnmuteCallback getOnmute();

  @JsProperty
  void setOnunmute(OnunmuteCallback onunmute);

  @JsProperty
  OnunmuteCallback getOnunmute();

  @JsProperty
  void setReadyState(String readyState);

  @JsProperty
  String getReadyState();

  @JsProperty
  void setRemote(boolean remote);

  @JsProperty
  boolean isRemote();

  void stop();

}
