/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.EventTarget;
import jsinterop.annotations.JsFunction;
import elemental2.Event;
import java.lang.Object;
import java.lang.String;
import elemental2.MediaStream.OnactiveCallback;
import elemental2.MediaStream.OnaddtrackCallback;
import elemental2.MediaStream.OnendedCallback;
import elemental2.MediaStream.OninactiveCallback;
import elemental2.MediaStream.OnremovetrackCallback;
import elemental2.MediaStreamTrack;
import elemental2.MediaStream.AddEventListenerListenerCallback;
import elemental2.EventListener;
import jsinterop.annotations.JsMethod;
import elemental2.MediaStream.RemoveEventListenerListenerCallback;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class MediaStream implements EventTarget {
  @JsFunction
  public interface AddEventListenerListenerCallback {
    boolean onInvoke(Event a);

  }
  @JsFunction
  public interface OnactiveCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnaddtrackCallback {
    Object onInvoke(Object a);

  }
  @JsFunction
  public interface OnendedCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OninactiveCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnremovetrackCallback {
    Object onInvoke(Object a);

  }
  @JsFunction
  public interface RemoveEventListenerListenerCallback {
    boolean onInvoke(Event a);

  }
  public boolean active;
  public boolean ended;
  public String id;
  public String label;
  public OnactiveCallback onactive;
  public OnaddtrackCallback onaddtrack;
  public OnendedCallback onended;
  public OninactiveCallback oninactive;
  public OnremovetrackCallback onremovetrack;
  
  public MediaStream(MediaStreamTrack[] streamOrTracks) {}

  public MediaStream() {}

  public MediaStream(MediaStream streamOrTracks) {}

  public native void addEventListener(String type, AddEventListenerListenerCallback listener, boolean useCapture);

  public native void addEventListener(String type, EventListener listener, boolean useCapture);

  public native void addEventListener(String type, AddEventListenerListenerCallback listener);

  public native void addEventListener(String type, EventListener listener);

  public native Object addTrack(MediaStreamTrack track);

  @JsMethod(name = "clone")
  public native MediaStream clone_();

  public native boolean dispatchEvent(Event evt);

  public native MediaStreamTrack[] getAudioTracks();

  public native MediaStreamTrack getTrackById(String trackId);

  public native MediaStreamTrack[] getTracks();

  public native MediaStreamTrack[] getVideoTracks();

  public native void removeEventListener(String type, RemoveEventListenerListenerCallback listener, boolean useCapture);

  public native void removeEventListener(String type, EventListener listener, boolean useCapture);

  public native void removeEventListener(String type, RemoveEventListenerListenerCallback listener);

  public native void removeEventListener(String type, EventListener listener);

  public native Object removeTrack(MediaStreamTrack track);

  public native Object stop();

  public native void addEventListener(String type, elemental2.EventTarget.AddEventListenerListenerCallback listener, boolean useCapture);

  public native void removeEventListener(String type, elemental2.EventTarget.RemoveEventListenerListenerCallback listener, boolean useCapture);

}
