/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import elemental2.MediaKeySystemAccess.GetConfigurationAudioCapabilitiesType;
import java.lang.String;
import elemental2.MediaKeySystemAccess.GetConfigurationVideoCapabilitiesType;
import elemental2.Promise;
import elemental2.MediaKeys;
import elemental2.MediaKeySystemAccess.GetConfigurationType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public interface MediaKeySystemAccess {
  @JsType
  public interface GetConfigurationType {
    @JsProperty
    void setAudioCapabilities(GetConfigurationAudioCapabilitiesType[] audioCapabilities);

    @JsProperty
    GetConfigurationAudioCapabilitiesType[] getAudioCapabilities();

    @JsProperty
    void setDistinctiveIdentifier(String distinctiveIdentifier);

    @JsProperty
    String getDistinctiveIdentifier();

    @JsProperty
    void setInitDataTypes(String[] initDataTypes);

    @JsProperty
    String[] getInitDataTypes();

    @JsProperty
    void setPersistentState(String persistentState);

    @JsProperty
    String getPersistentState();

    @JsProperty
    void setVideoCapabilities(GetConfigurationVideoCapabilitiesType[] videoCapabilities);

    @JsProperty
    GetConfigurationVideoCapabilitiesType[] getVideoCapabilities();

  }
  @JsType
  public interface GetConfigurationAudioCapabilitiesType {
    @JsProperty
    void setContentType(String contentType);

    @JsProperty
    String getContentType();

    @JsProperty
    void setRobustness(String robustness);

    @JsProperty
    String getRobustness();

  }
  @JsType
  public interface GetConfigurationVideoCapabilitiesType {
    @JsProperty
    void setContentType(String contentType);

    @JsProperty
    String getContentType();

    @JsProperty
    void setRobustness(String robustness);

    @JsProperty
    String getRobustness();

  }
  Promise<MediaKeys> createMediaKeys();

  GetConfigurationType getConfiguration();

  @JsProperty
  void setKeySystem(String keySystem);

  @JsProperty
  String getKeySystem();

}
