/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.Iterable;
import java.lang.Object;
import jsinterop.annotations.JsFunction;
import elemental2.Map.ForEachACallback;
import elemental2.IteratorIterable;
import jsinterop.annotations.JsMethod;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class Map<KEY, VALUE> implements Iterable</* KEY | VALUE */ Object[]> {
  @JsFunction
  public interface ForEachACallback<VALUE, KEY, MAP> {
    Object onInvoke(VALUE a, KEY b, MAP c);

  }
  public double size;
  
  public Map(/* KEY | VALUE */ Object[][] iterable) {}

  public Map() {}

  public Map(Iterable</* KEY | VALUE */ Object[]> iterable) {}

  public native void clear();

  public native boolean delete(KEY a);

  public native Object entries();

  public native <MAP, THIS> Object forEach(ForEachACallback<VALUE, KEY, MAP> a, THIS b);

  public native <MAP> Object forEach(ForEachACallback<VALUE, KEY, MAP> a);

  public native VALUE get(KEY a);

  public native boolean has(KEY a);

  public native IteratorIterable<KEY> keys();

  public native <THIS> THIS set(KEY a, VALUE b);

  public native IteratorIterable<VALUE> values();

  @JsMethod(name = "entries")
  public native IteratorIterable<KEY[]> entriesAsArrayIteratorIterable();

}
