/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.UIEvent;
import jsinterop.annotations.JsProperty;
import java.lang.String;
import elemental2.Window;
import elemental2.KeyboardEvent.KeyboardEvent_InstanceOpt_eventInitDictType;
import elemental2.UIEvent.UIEvent_InstanceOpt_eventInitDictType;
import java.lang.Object;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class KeyboardEvent extends UIEvent {
  @JsType
  public interface KeyboardEvent_InstanceOpt_eventInitDictType {
    @JsProperty
    void setAltKey(boolean altKey);

    @JsProperty
    boolean isAltKey();

    @JsProperty
    void setBubbles(boolean bubbles);

    @JsProperty
    boolean isBubbles();

    @JsProperty
    void setCancelable(boolean cancelable);

    @JsProperty
    boolean isCancelable();

    @JsProperty
    void setChar(String char_);

    @JsProperty
    String getChar();

    @JsProperty
    void setCode(String code);

    @JsProperty
    String getCode();

    @JsProperty
    void setCtrlKey(boolean ctrlKey);

    @JsProperty
    boolean isCtrlKey();

    @JsProperty
    void setDetail(double detail);

    @JsProperty
    double getDetail();

    @JsProperty
    void setKey(String key);

    @JsProperty
    String getKey();

    @JsProperty
    void setLocale(String locale);

    @JsProperty
    String getLocale();

    @JsProperty
    void setLocation(double location);

    @JsProperty
    double getLocation();

    @JsProperty
    void setMetaKey(boolean metaKey);

    @JsProperty
    boolean isMetaKey();

    @JsProperty
    void setRepeat(boolean repeat);

    @JsProperty
    boolean isRepeat();

    @JsProperty
    void setShiftKey(boolean shiftKey);

    @JsProperty
    boolean isShiftKey();

    @JsProperty
    void setView(Window view);

    @JsProperty
    Window getView();

  }
  public boolean altKey;
  @JsProperty(name = "char")
  public String char_;
  public String code;
  public boolean ctrlKey;
  public String key;
  public String keyIdentifier;
  public String locale;
  public double location;
  public boolean metaKey;
  public boolean repeat;
  public boolean shiftKey;
  
  public KeyboardEvent(String type, KeyboardEvent_InstanceOpt_eventInitDictType eventInitDict) {
    // This call is only there for java compilation purpose.
    super((String) null, (UIEvent_InstanceOpt_eventInitDictType) null);
  }

  public KeyboardEvent(String type) {
    // This call is only there for java compilation purpose.
    super((String) null, (UIEvent_InstanceOpt_eventInitDictType) null);
  }

  public native boolean getModifierState(String keyIdentifierArg);

  public native Object initKeyboardEvent(String typeArg, boolean canBubbleArg, boolean cancelableArg, Window viewArg, String keyIdentifierArg, double keyLocationArg, String modifiersList);

}
