/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsFunction;
import java.lang.Object;
import java.lang.String;
import elemental2.JSONType.ParseOpt_reviverCallback;
import elemental2.JSONType.StringifyOpt_replacerCallback;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class JSONType {
  @JsFunction
  public interface ParseOpt_reviverCallback {
    Object onInvoke(String a, Object b);

  }
  @JsFunction
  public interface StringifyOpt_replacerCallback {
    Object onInvoke(String a, Object b);

  }
  public native Object parse(String jsonStr, ParseOpt_reviverCallback reviver);

  public native Object parse(String jsonStr);

  public native String stringify(Object jsonObj, StringifyOpt_replacerCallback replacer, String space);

  public native String stringify(Object jsonObj);

  public native String stringify(Object jsonObj, String[] replacer, String space);

  public native String stringify(Object jsonObj, StringifyOpt_replacerCallback replacer);

  public native String stringify(Object jsonObj, String[] replacer);

  public native String stringify(Object jsonObj, String[] replacer, double space);

  public native String stringify(Object jsonObj, StringifyOpt_replacerCallback replacer, double space);

}
