/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.IArrayLike;
import java.lang.Double;
import jsinterop.annotations.JsProperty;
import java.lang.Object;
import elemental2.ArrayBufferView;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public interface ITypedArray extends IArrayLike<Double> {
  @JsProperty(name = "BYTES_PER_ELEMENT")
  void setBYTES_PER_ELEMENT(double BYTES_PER_ELEMENT);

  @JsProperty(name = "BYTES_PER_ELEMENT")
  double getBYTES_PER_ELEMENT();

  ITypedArray fill(double value, double begin, double end);

  ITypedArray fill(double value);

  ITypedArray fill(double value, double begin);

  @JsProperty
  void setLength(double length);

  @JsProperty
  double getLength();

  Object set(double[] array, double offset);

  Object set(ArrayBufferView array, double offset);

  Object set(double[] array);

  Object set(ArrayBufferView array);

  ITypedArray subarray(double begin, double end);

  ITypedArray subarray(double begin);

}
