/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.DOMStringList;
import java.lang.String;
import elemental2.IDBTransaction;
import elemental2.IDBRequest;
import java.lang.Object;
import elemental2.Date;
import elemental2.IDBKeyRange;
import elemental2.IDBIndex;
import elemental2.NativeObject;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class IDBObjectStore {
  public boolean autoIncrement;
  public DOMStringList indexNames;
  public String keyPath;
  public String name;
  public IDBTransaction transaction;
  
  public native IDBRequest add(Object value, Object[] key);

  public native IDBRequest add(Object value);

  public native IDBRequest add(Object value, double key);

  public native IDBRequest add(Object value, String key);

  public native IDBRequest add(Object value, Date key);

  public native IDBRequest clear();

  public native IDBRequest count(IDBKeyRange key);

  public native IDBRequest count();

  public native IDBRequest count(double key);

  public native IDBRequest count(String key);

  public native IDBRequest count(Date key);

  public native IDBRequest count(Object[] key);

  public native IDBIndex createIndex(String name, String[] keyPath, NativeObject paramters);

  public native IDBIndex createIndex(String name, String keyPath, NativeObject paramters);

  public native IDBIndex createIndex(String name, String[] keyPath);

  public native IDBIndex createIndex(String name, String keyPath);

  public native IDBRequest delete(Object[] key);

  public native IDBRequest delete(double key);

  public native IDBRequest delete(String key);

  public native IDBRequest delete(Date key);

  public native Object deleteIndex(String indexName);

  public native IDBRequest get(IDBKeyRange key);

  public native IDBRequest get(double key);

  public native IDBRequest get(String key);

  public native IDBRequest get(Date key);

  public native IDBRequest get(Object[] key);

  public native IDBIndex index(String name);

  public native IDBRequest openCursor(IDBKeyRange range, String direction);

  public native IDBRequest openCursor();

  public native IDBRequest openCursor(IDBKeyRange range);

  public native IDBRequest openCursor(IDBKeyRange range, double direction);

  public native IDBRequest put(Object value, Object[] key);

  public native IDBRequest put(Object value);

  public native IDBRequest put(Object value, double key);

  public native IDBRequest put(Object value, String key);

  public native IDBRequest put(Object value, Date key);

}
