/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import java.lang.Object;
import java.lang.String;
import elemental2.Date;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class IDBKeyRange {
  public static native IDBKeyRange bound(Object[] left, Object[] right, boolean openLeft, boolean openRight);

  public static native IDBKeyRange bound(double left, Object[] right, boolean openLeft, boolean openRight);

  public static native IDBKeyRange bound(String left, Object[] right, boolean openLeft, boolean openRight);

  public static native IDBKeyRange bound(Date left, Object[] right, boolean openLeft, boolean openRight);

  public static native IDBKeyRange bound(Date left, double right, boolean openLeft, boolean openRight);

  public static native IDBKeyRange bound(Date left, String right, boolean openLeft, boolean openRight);

  public static native IDBKeyRange bound(Date left, Date right, boolean openLeft, boolean openRight);

  public static native IDBKeyRange bound(String left, double right, boolean openLeft, boolean openRight);

  public static native IDBKeyRange bound(String left, String right, boolean openLeft, boolean openRight);

  public static native IDBKeyRange bound(String left, Date right, boolean openLeft, boolean openRight);

  public static native IDBKeyRange bound(double left, double right, boolean openLeft, boolean openRight);

  public static native IDBKeyRange bound(double left, String right, boolean openLeft, boolean openRight);

  public static native IDBKeyRange bound(double left, Date right, boolean openLeft, boolean openRight);

  public static native IDBKeyRange bound(Object[] left, double right, boolean openLeft, boolean openRight);

  public static native IDBKeyRange bound(Object[] left, String right, boolean openLeft, boolean openRight);

  public static native IDBKeyRange bound(Object[] left, Date right, boolean openLeft, boolean openRight);

  public static native IDBKeyRange bound(Object[] left, Object[] right);

  public static native IDBKeyRange bound(double left, Object[] right);

  public static native IDBKeyRange bound(String left, Object[] right);

  public static native IDBKeyRange bound(Date left, Object[] right);

  public static native IDBKeyRange bound(Date left, double right);

  public static native IDBKeyRange bound(Date left, String right);

  public static native IDBKeyRange bound(Date left, Date right);

  public static native IDBKeyRange bound(String left, double right);

  public static native IDBKeyRange bound(String left, String right);

  public static native IDBKeyRange bound(String left, Date right);

  public static native IDBKeyRange bound(double left, double right);

  public static native IDBKeyRange bound(double left, String right);

  public static native IDBKeyRange bound(double left, Date right);

  public static native IDBKeyRange bound(Object[] left, double right);

  public static native IDBKeyRange bound(Object[] left, String right);

  public static native IDBKeyRange bound(Object[] left, Date right);

  public static native IDBKeyRange bound(Object[] left, Object[] right, boolean openLeft);

  public static native IDBKeyRange bound(double left, Object[] right, boolean openLeft);

  public static native IDBKeyRange bound(String left, Object[] right, boolean openLeft);

  public static native IDBKeyRange bound(Date left, Object[] right, boolean openLeft);

  public static native IDBKeyRange bound(Date left, double right, boolean openLeft);

  public static native IDBKeyRange bound(Date left, String right, boolean openLeft);

  public static native IDBKeyRange bound(Date left, Date right, boolean openLeft);

  public static native IDBKeyRange bound(String left, double right, boolean openLeft);

  public static native IDBKeyRange bound(String left, String right, boolean openLeft);

  public static native IDBKeyRange bound(String left, Date right, boolean openLeft);

  public static native IDBKeyRange bound(double left, double right, boolean openLeft);

  public static native IDBKeyRange bound(double left, String right, boolean openLeft);

  public static native IDBKeyRange bound(double left, Date right, boolean openLeft);

  public static native IDBKeyRange bound(Object[] left, double right, boolean openLeft);

  public static native IDBKeyRange bound(Object[] left, String right, boolean openLeft);

  public static native IDBKeyRange bound(Object[] left, Date right, boolean openLeft);

  public static native IDBKeyRange lowerBound(Object[] bound, boolean open);

  public static native IDBKeyRange lowerBound(double bound, boolean open);

  public static native IDBKeyRange lowerBound(String bound, boolean open);

  public static native IDBKeyRange lowerBound(Date bound, boolean open);

  public static native IDBKeyRange lowerBound(Object[] bound);

  public static native IDBKeyRange lowerBound(double bound);

  public static native IDBKeyRange lowerBound(String bound);

  public static native IDBKeyRange lowerBound(Date bound);

  public static native IDBKeyRange only(Object[] value);

  public static native IDBKeyRange only(double value);

  public static native IDBKeyRange only(String value);

  public static native IDBKeyRange only(Date value);

  public static native IDBKeyRange upperBound(Object[] bound, boolean open);

  public static native IDBKeyRange upperBound(double bound, boolean open);

  public static native IDBKeyRange upperBound(String bound, boolean open);

  public static native IDBKeyRange upperBound(Date bound, boolean open);

  public static native IDBKeyRange upperBound(Object[] bound);

  public static native IDBKeyRange upperBound(double bound);

  public static native IDBKeyRange upperBound(String bound);

  public static native IDBKeyRange upperBound(Date bound);

  public Object lower;
  public Object lowerOpen;
  public Object upper;
  public Object upperOpen;
  
  
}
