/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import java.lang.String;
import elemental2.IDBObjectStore;
import elemental2.IDBRequest;
import elemental2.IDBKeyRange;
import elemental2.Date;
import java.lang.Object;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class IDBIndex {
  public String keyPath;
  public String name;
  public IDBObjectStore objectStore;
  public boolean unique;
  
  public native IDBRequest get(IDBKeyRange key);

  public native IDBRequest get(double key);

  public native IDBRequest get(String key);

  public native IDBRequest get(Date key);

  public native IDBRequest get(Object[] key);

  public native IDBRequest getKey(IDBKeyRange key);

  public native IDBRequest getKey(double key);

  public native IDBRequest getKey(String key);

  public native IDBRequest getKey(Date key);

  public native IDBRequest getKey(Object[] key);

  public native IDBRequest openCursor(IDBKeyRange range, String direction);

  public native IDBRequest openCursor();

  public native IDBRequest openCursor(IDBKeyRange range);

  public native IDBRequest openCursor(IDBKeyRange range, double direction);

  public native IDBRequest openKeyCursor(IDBKeyRange range, String direction);

  public native IDBRequest openKeyCursor();

  public native IDBRequest openKeyCursor(IDBKeyRange range);

  public native IDBRequest openKeyCursor(IDBKeyRange range, double direction);

}
