/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import java.lang.String;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class IDBDatabaseException {
  public static double ABORT_ERR;
  public static double CONSTRAINT_ERR;
  public static double DATA_ERR;
  public static double NON_TRANSIENT_ERR;
  public static double NOT_ALLOWED_ERR;
  public static double NOT_FOUND_ERR;
  public static double QUOTA_ERR;
  public static double READ_ONLY_ERR;
  public static double TIMEOUT_ERR;
  public static double TRANSACTION_INACTIVE_ERR;
  public static double UNKNOWN_ERR;
  
  public double code;
  public String message;
  
  
}
