/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.EventTarget;
import jsinterop.annotations.JsFunction;
import elemental2.Event;
import java.lang.Object;
import java.lang.String;
import elemental2.DOMStringList;
import elemental2.IDBDatabase.OnabortCallback;
import elemental2.IDBDatabase.OnerrorCallback;
import elemental2.IDBDatabase.OnversionchangeCallback;
import elemental2.IDBDatabase.AddEventListenerListenerCallback;
import elemental2.EventListener;
import elemental2.IDBObjectStore;
import elemental2.NativeObject;
import elemental2.IDBDatabase.RemoveEventListenerListenerCallback;
import elemental2.IDBRequest;
import elemental2.IDBTransaction;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class IDBDatabase implements EventTarget {
  @JsFunction
  public interface AddEventListenerListenerCallback {
    boolean onInvoke(Event a);

  }
  @JsFunction
  public interface OnabortCallback {
    Object onInvoke(Object... a);

  }
  @JsFunction
  public interface OnerrorCallback {
    Object onInvoke(Object... a);

  }
  @JsFunction
  public interface OnversionchangeCallback {
    Object onInvoke(Object... a);

  }
  @JsFunction
  public interface RemoveEventListenerListenerCallback {
    boolean onInvoke(Event a);

  }
  public String description;
  public String name;
  public DOMStringList objectStoreNames;
  public OnabortCallback onabort;
  public OnerrorCallback onerror;
  public OnversionchangeCallback onversionchange;
  public String version;
  
  public native void addEventListener(String type, AddEventListenerListenerCallback listener, boolean useCapture);

  public native void addEventListener(String type, EventListener listener, boolean useCapture);

  public native void addEventListener(String type, AddEventListenerListenerCallback listener);

  public native void addEventListener(String type, EventListener listener);

  public native Object close();

  public native IDBObjectStore createObjectStore(String name, NativeObject parameters);

  public native IDBObjectStore createObjectStore(String name);

  public native Object deleteObjectStore(String name);

  public native boolean dispatchEvent(Event evt);

  public native void removeEventListener(String type, RemoveEventListenerListenerCallback listener, boolean useCapture);

  public native void removeEventListener(String type, EventListener listener, boolean useCapture);

  public native void removeEventListener(String type, RemoveEventListenerListenerCallback listener);

  public native void removeEventListener(String type, EventListener listener);

  public native IDBRequest setVersion(String version);

  public native IDBTransaction transaction(String[] storeNames, String mode);

  public native IDBTransaction transaction(String[] storeNames);

  public native IDBTransaction transaction(String[] storeNames, double mode);

  public native void addEventListener(String type, elemental2.EventTarget.AddEventListenerListenerCallback listener, boolean useCapture);

  public native void removeEventListener(String type, elemental2.EventTarget.RemoveEventListenerListenerCallback listener, boolean useCapture);

}
