/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import java.lang.Object;
import jsinterop.annotations.JsMethod;
import java.lang.String;
import elemental2.Date;
import elemental2.IDBRequest;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class IDBCursor {
  public static double NEXT;
  public static double NEXT_NO_DUPLICATE;
  public static double PREV;
  public static double PREV_NO_DUPLICATE;
  
  public double direction;
  public /* double | String | Date | Object */ Object key;
  public double primaryKey;
  public Object source;
  
  public native Object advance(double count);

  @JsMethod(name = "continue")
  public native Object continue_(Object[] key);

  @JsMethod(name = "continue")
  public native Object continue_();

  @JsMethod(name = "continue")
  public native Object continue_(double key);

  @JsMethod(name = "continue")
  public native Object continue_(String key);

  @JsMethod(name = "continue")
  public native Object continue_(Date key);

  public native IDBRequest delete();

  public native IDBRequest update(Object value);

}
