/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.Event;
import jsinterop.annotations.JsProperty;
import java.lang.String;
import elemental2.HashChangeEvent.HashChangeEvent_InstanceOpt_eventInitDictType;
import elemental2.Event.Event_InstanceOpt_eventInitDictType;
import java.lang.Object;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class HashChangeEvent extends Event {
  @JsType
  public interface HashChangeEvent_InstanceOpt_eventInitDictType {
    @JsProperty
    void setNewURL(String newURL);

    @JsProperty
    String getNewURL();

    @JsProperty
    void setOldURL(String oldURL);

    @JsProperty
    String getOldURL();

  }
  public String newURL;
  public String oldURL;
  
  public HashChangeEvent(String type, HashChangeEvent_InstanceOpt_eventInitDictType eventInitDict) {
    // This call is only there for java compilation purpose.
    super((String) null, (Event_InstanceOpt_eventInitDictType) null);
  }

  public HashChangeEvent(String type) {
    // This call is only there for java compilation purpose.
    super((String) null, (Event_InstanceOpt_eventInitDictType) null);
  }

  public native Object initHashChangeEvent(String typeArg, boolean canBubbleArg, boolean cancelableArg, String oldURLArg, String newURLArg);

}
