/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.HTMLMediaElement;
import jsinterop.annotations.JsProperty;
import java.lang.String;
import elemental2.HTMLVideoElement.GetVideoPlaybackQualityType;
import java.lang.Object;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class HTMLVideoElement extends HTMLMediaElement {
  @JsType
  public interface GetVideoPlaybackQualityType {
    @JsProperty
    void setCorruptedVideoFrames(double corruptedVideoFrames);

    @JsProperty
    double getCorruptedVideoFrames();

    @JsProperty
    void setCreationTime(double creationTime);

    @JsProperty
    double getCreationTime();

    @JsProperty
    void setDroppedVideoFrames(double droppedVideoFrames);

    @JsProperty
    double getDroppedVideoFrames();

    @JsProperty
    void setTotalFrameDelay(double totalFrameDelay);

    @JsProperty
    double getTotalFrameDelay();

    @JsProperty
    void setTotalVideoFrames(double totalVideoFrames);

    @JsProperty
    double getTotalVideoFrames();

  }
  public double height;
  public String poster;
  public double videoHeight;
  public double videoWidth;
  public double webkitDecodedFrameCount;
  public boolean webkitDisplayingFullscreen;
  public double webkitDroppedFrameCount;
  public boolean webkitSupportsFullscreen;
  public double width;
  
  public native GetVideoPlaybackQualityType getVideoPlaybackQuality();

  public native Object webkitEnterFullScreen();

  public native Object webkitEnterFullscreen();

  public native Object webkitExitFullScreen();

  public native Object webkitExitFullscreen();

}
