/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.HTMLElement;
import java.lang.String;
import elemental2.Document;
import elemental2.HTMLFormElement;
import java.lang.Object;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class HTMLObjectElement extends HTMLElement {
  public String align;
  public String archive;
  public String border;
  public String code;
  public String codeBase;
  public String codeType;
  public Document contentDocument;
  public String data;
  public boolean declare;
  public HTMLFormElement form;
  public String height;
  public double hspace;
  public String name;
  public String standby;
  public double tabIndex;
  public String type;
  public String useMap;
  public double vspace;
  public String width;
  
  public native String CallFunction(String xmlString);

  public native String GetVariable(String varName);

  public native Object GotoFrame(double frameNumber);

  public native boolean IsPlaying();

  public native Object LoadMovie(double layerNumber, String url);

  public native Object Pan(double x, double y, double mode);

  public native double PercentLoaded();

  public native Object Play();

  public native Object Rewind();

  public native Object SetVariable(String variableName, String value);

  public native Object SetZoomRect(double left, double top, double right, double bottom);

  public native Object StopPlay();

  public native Object TCallFrame(String target, double frameNumber);

  public native Object TCallLabel(String target, String label);

  public native double TCurentFrame(String target);

  public native String TCurrentLabel(String target);

  public native String TGetProperty(String target, double property);

  public native double TGetPropertyAsNumber(String target, double property);

  public native Object TGotoFrame(String target, double frameNumber);

  public native Object TGotoLabel(String target, String label);

  public native Object TPlay(double target);

  public native Object TSetProperty(double target, double property, double value);

  public native Object TSetProperty(double target, double property, String value);

  public native Object TStopPlay(double target);

  public native double TotalFrames();

  public native Object Zoom(double percent);

}
