/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.HTMLElement;
import jsinterop.annotations.JsFunction;
import java.lang.Object;
import elemental2.Event;
import elemental2.TimeRanges;
import java.lang.String;
import elemental2.MediaError;
import elemental2.MediaKeys;
import elemental2.HTMLMediaElement.OnabortCallback;
import elemental2.HTMLMediaElement.OncanplayCallback;
import elemental2.HTMLMediaElement.OncanplaythroughCallback;
import elemental2.HTMLMediaElement.OndurationchangeCallback;
import elemental2.HTMLMediaElement.OnemptiedCallback;
import elemental2.HTMLMediaElement.OnendedCallback;
import elemental2.HTMLMediaElement.OnerrorCallback;
import elemental2.HTMLMediaElement.OnloadeddataCallback;
import elemental2.HTMLMediaElement.OnloadedmetadataCallback;
import elemental2.HTMLMediaElement.OnloadstartCallback;
import elemental2.HTMLMediaElement.OnpauseCallback;
import elemental2.HTMLMediaElement.OnplayCallback;
import elemental2.HTMLMediaElement.OnplayingCallback;
import elemental2.HTMLMediaElement.OnprogressCallback;
import elemental2.HTMLMediaElement.OnratechangeCallback;
import elemental2.HTMLMediaElement.OnseekedCallback;
import elemental2.HTMLMediaElement.OnseekingCallback;
import elemental2.HTMLMediaElement.OnstalledCallback;
import elemental2.HTMLMediaElement.OnsuspendCallback;
import elemental2.HTMLMediaElement.OntimeupdateCallback;
import elemental2.HTMLMediaElement.OnvolumechangeCallback;
import elemental2.HTMLMediaElement.OnwaitingCallback;
import elemental2.TextTrackList;
import elemental2.TextTrack;
import elemental2.Date;
import elemental2.Promise;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class HTMLMediaElement extends HTMLElement {
  @JsFunction
  public interface OnabortCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OncanplayCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OncanplaythroughCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OndurationchangeCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnemptiedCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnendedCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnerrorCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnloadeddataCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnloadedmetadataCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnloadstartCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnpauseCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnplayCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnplayingCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnprogressCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnratechangeCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnseekedCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnseekingCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnstalledCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnsuspendCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OntimeupdateCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnvolumechangeCallback {
    Object onInvoke(Event a);

  }
  @JsFunction
  public interface OnwaitingCallback {
    Object onInvoke(Event a);

  }
  public static double HAVE_CURRENT_DATA;
  public static double HAVE_ENOUGH_DATA;
  public static double HAVE_FUTURE_DATA;
  public static double HAVE_METADATA;
  public static double HAVE_NOTHING;
  
  public boolean autobuffer;
  public boolean autoplay;
  public TimeRanges buffered;
  public boolean controls;
  public String currentSrc;
  public double currentTime;
  public double defaultPlaybackRate;
  public double duration;
  public boolean ended;
  public MediaError error;
  public boolean loop;
  public MediaKeys mediaKeys;
  public boolean muted;
  public double networkState;
  public OnabortCallback onabort;
  public OncanplayCallback oncanplay;
  public OncanplaythroughCallback oncanplaythrough;
  public OndurationchangeCallback ondurationchange;
  public OnemptiedCallback onemptied;
  public OnendedCallback onended;
  public OnerrorCallback onerror;
  public OnloadeddataCallback onloadeddata;
  public OnloadedmetadataCallback onloadedmetadata;
  public OnloadstartCallback onloadstart;
  public OnpauseCallback onpause;
  public OnplayCallback onplay;
  public OnplayingCallback onplaying;
  public OnprogressCallback onprogress;
  public OnratechangeCallback onratechange;
  public OnseekedCallback onseeked;
  public OnseekingCallback onseeking;
  public OnstalledCallback onstalled;
  public OnsuspendCallback onsuspend;
  public OntimeupdateCallback ontimeupdate;
  public OnvolumechangeCallback onvolumechange;
  public OnwaitingCallback onwaiting;
  public boolean paused;
  public double playbackRate;
  public TimeRanges played;
  public double readyState;
  public TimeRanges seekable;
  public boolean seeking;
  public String src;
  public TextTrackList textTracks;
  public double volume;
  
  public native TextTrack addTextTrack(String kind, String label, String language);

  public native TextTrack addTextTrack(String kind);

  public native TextTrack addTextTrack(String kind, String label);

  public native String canPlayType(String type);

  public native Date getStartDate();

  public native Object load();

  public native Object pause();

  public native Object play();

  public native Promise<Object> setMediaKeys(MediaKeys mediaKeys);

}
