/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.HTMLElement;
import elemental2.LinkStyle;
import java.lang.String;
import jsinterop.annotations.JsProperty;
import elemental2.Document;
import elemental2.StyleSheet;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class HTMLLinkElement extends HTMLElement implements LinkStyle {
  public String charset;
  public boolean disabled;
  public String href;
  public String hreflang;
  @JsProperty(name = "import")
  public Document import_;
  public String media;
  public String rel;
  public String rev;
  public StyleSheet sheet;
  public String target;
  public String type;
  
  @JsProperty
  public native void setSheet(StyleSheet sheet);

  @JsProperty
  public native StyleSheet getSheet();

}
