/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.HTMLElement;
import jsinterop.annotations.JsFunction;
import java.lang.Object;
import elemental2.Event;
import java.lang.String;
import elemental2.FileList;
import elemental2.HTMLFormElement;
import elemental2.NodeList;
import elemental2.HTMLLabelElement;
import elemental2.HTMLInputElement.OnwebkitspeechchangeCallback;
import elemental2.ValidityState;
import elemental2.Date;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class HTMLInputElement extends HTMLElement {
  @JsFunction
  public interface OnwebkitspeechchangeCallback {
    Object onInvoke(Event a);

  }
  public String accept;
  public String accessKey;
  public String align;
  public String alt;
  public String autocomplete;
  public boolean autofocus;
  public boolean checked;
  public boolean defaultChecked;
  public String defaultValue;
  public String dirname;
  public boolean disabled;
  public FileList files;
  public HTMLFormElement form;
  public String formAction;
  public String formEnctype;
  public String formMethod;
  public boolean formNoValidate;
  public String formTarget;
  public boolean indeterminate;
  public NodeList<HTMLLabelElement> labels;
  public String list;
  public String max;
  public double maxLength;
  public String min;
  public boolean multiple;
  public String name;
  public OnwebkitspeechchangeCallback onwebkitspeechchange;
  public String pattern;
  public String placeholder;
  public boolean readOnly;
  public boolean required;
  public double size;
  public String src;
  public String step;
  public double tabIndex;
  public String type;
  public String useMap;
  public String validationMessage;
  public ValidityState validity;
  public String value;
  public Date valueAsDate;
  public double valueAsNumber;
  public boolean webkitspeech;
  public boolean willValidate;
  
  public native void blur();

  public native boolean checkValidity();

  public native void click();

  public native void focus();

  public native boolean reportValidity();

  public native void select();

  public native Object setCustomValidity(String message);

  public native Object stepDown(double n);

  public native Object stepDown();

  public native Object stepUp(double n);

  public native Object stepUp();

}
