/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.HTMLCollection;
import elemental2.IArrayLike;
import jsinterop.annotations.JsOverlay;
import elemental2.RadioNodeList;
import java.lang.Object;
import java.lang.String;
import jsinterop.helper.JsObjects;
import jsinterop.annotations.JsMethod;
import jsinterop.annotations.JsProperty;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class HTMLFormControlsCollection<T> extends HTMLCollection<T> implements IArrayLike<T> {
  @JsOverlay
  public final RadioNodeList<Object> getAsObjectRadioNodeList(String key){
    return JsObjects.get(this, key);
  }

  @JsMethod(name = "namedItem")
  public native RadioNodeList<Object> namedItemAsObjectRadioNodeList(String name);

  @JsProperty
  public native void setLength(double length);

  @JsProperty
  public native double getLength();

}
