/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.Element;
import java.lang.String;
import elemental2.NativeObject;
import elemental2.ShadowRoot;
import elemental2.CSSStyleDeclaration;
import java.lang.Object;
import elemental2.NodeList;
import elemental2.Node;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class HTMLElement extends Element {
  public String className;
  public Element contextMenu;
  public NativeObject dataset;
  public String dir;
  public boolean draggable;
  public NativeObject dropzone;
  public boolean hidden;
  public String id;
  public String lang;
  public double offsetHeight;
  public double offsetLeft;
  public Element offsetParent;
  public double offsetTop;
  public double offsetWidth;
  public ShadowRoot shadowRoot;
  public boolean spellcheck;
  public CSSStyleDeclaration style;
  public double tabIndex;
  public String title;
  
  public native Object attachedCallback();

  public native ShadowRoot createShadowRoot();

  public native Object createdCallback();

  public native Object detachedCallback();

  public native NodeList<Node> getDestinationInsertionPoints();

  public native NodeList<Element> getElementsByClassName(String classNames);

  public native ShadowRoot webkitCreateShadowRoot();

}
