/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.Document;
import java.lang.String;
import elemental2.HTMLCollection;
import elemental2.HTMLAnchorElement;
import elemental2.HTMLAppletElement;
import elemental2.HTMLBodyElement;
import elemental2.HTMLFormElement;
import elemental2.HTMLImageElement;
import java.lang.Object;
import elemental2.NodeIterator;
import elemental2.Node;
import elemental2.NodeFilter;
import elemental2.TreeWalker;
import elemental2.NodeList;
import elemental2.Element;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class HTMLDocument extends Document {
  public String URL;
  public HTMLCollection<HTMLAnchorElement> anchors;
  public HTMLCollection<HTMLAppletElement> applets;
  public HTMLBodyElement body;
  public String cookie;
  public String domain;
  public HTMLCollection<HTMLFormElement> forms;
  public HTMLCollection<HTMLImageElement> images;
  public HTMLCollection</* HTMLAnchorElement | HTMLAreaElement */ Object> links;
  public String referrer;
  public String title;
  
  public native void close();

  public native NodeIterator createNodeIterator(Node root, double whatToShow, NodeFilter filter, boolean entityReferenceExpansion);

  public native NodeIterator createNodeIterator(Node root);

  public native NodeIterator createNodeIterator(Node root, double whatToShow);

  public native NodeIterator createNodeIterator(Node root, double whatToShow, NodeFilter filter);

  public native TreeWalker createTreeWalker(Node root, double whatToShow, NodeFilter filter, boolean entityReferenceExpansion);

  public native TreeWalker createTreeWalker(Node root);

  public native TreeWalker createTreeWalker(Node root, double whatToShow);

  public native TreeWalker createTreeWalker(Node root, double whatToShow, NodeFilter filter);

  public native NodeList<Element> getElementsByName(String elementName);

  public native void open();

  public native void write(String text);

  public native void writeln(String text);

}
