/*
 * Copyright 2016 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2;

import jsinterop.annotations.JsType;
import jsinterop.annotations.JsPackage;
import elemental2.HTMLElement;
import java.lang.String;
import java.lang.Object;
import elemental2.Element;
import elemental2.MouseEvent;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class HTMLDialogElement extends HTMLElement {
  public boolean open;
  public String returnValue;
  
  public native Object close(String returnValue);

  public native Object close();

  public native Object show(Element anchor);

  public native Object show();

  public native Object show(MouseEvent anchor);

  public native Object showModal(Element anchor);

  public native Object showModal();

  public native Object showModal(MouseEvent anchor);

}
